/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.node.service;

import com.alipay.sofa.registry.common.model.CommonResponse;
import com.alipay.sofa.registry.common.model.GenericResponse;
import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.common.model.dataserver.ClientOffRequest;
import com.alipay.sofa.registry.common.model.dataserver.Datum;
import com.alipay.sofa.registry.common.model.dataserver.GetDataRequest;
import com.alipay.sofa.registry.common.model.dataserver.GetDataVersionRequest;
import com.alipay.sofa.registry.common.model.dataserver.PublishDataRequest;
import com.alipay.sofa.registry.common.model.dataserver.SessionServerRegisterRequest;
import com.alipay.sofa.registry.common.model.dataserver.UnPublishDataRequest;
import com.alipay.sofa.registry.common.model.store.Publisher;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.exchange.NodeExchanger;
import com.alipay.sofa.registry.remoting.exchange.RequestException;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.remoting.exchange.message.Response;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import com.alipay.sofa.registry.server.session.node.NodeManager;
import com.alipay.sofa.registry.server.session.node.SessionProcessIdGenerator;
import com.alipay.sofa.registry.server.session.node.service.DataNodeService;
import com.alipay.sofa.registry.timer.AsyncHashedWheelTimer;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Autowired;

public class DataNodeServiceImpl
implements DataNodeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeServiceImpl.class);
    @Autowired
    private NodeExchanger dataNodeExchanger;
    @Autowired
    private NodeManager dataNodeManager;
    @Autowired
    private SessionServerConfig sessionServerConfig;
    private AsyncHashedWheelTimer asyncHashedWheelTimer;

    public DataNodeServiceImpl() {
        ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder();
        threadFactoryBuilder.setDaemon(true);
        this.asyncHashedWheelTimer = new AsyncHashedWheelTimer(threadFactoryBuilder.setNameFormat("Registry-DataNodeServiceImpl-WheelTimer").build(), 100L, TimeUnit.MILLISECONDS, 1024, threadFactoryBuilder.setNameFormat("Registry-DataNodeServiceImpl-WheelExecutor-%d").build(), new AsyncHashedWheelTimer.TaskFailedCallback(){

            public void executionRejected(Throwable e) {
                LOGGER.error("executionRejected: " + e.getMessage(), e);
            }

            public void executionFailed(Throwable e) {
                LOGGER.error("executionFailed: " + e.getMessage(), e);
            }
        });
    }

    @Override
    public void register(final Publisher publisher) {
        try {
            CommonResponse commonResponse;
            Request<PublishDataRequest> publisherRequest = new Request<PublishDataRequest>(){
                private URL url;

                public PublishDataRequest getRequestBody() {
                    PublishDataRequest publishDataRequest = new PublishDataRequest();
                    publishDataRequest.setPublisher(publisher);
                    publishDataRequest.setSessionServerProcessId(SessionProcessIdGenerator.getSessionProcessId());
                    return publishDataRequest;
                }

                public URL getRequestUrl() {
                    if (this.url == null) {
                        this.url = DataNodeServiceImpl.this.getUrl(publisher.getDataInfoId());
                    }
                    return this.url;
                }
            };
            Response response = this.dataNodeExchanger.request((Request)publisherRequest);
            Object result = response.getResult();
            if (result instanceof CommonResponse && !(commonResponse = (CommonResponse)result).isSuccess()) {
                LOGGER.error("PublishDataRequest get server response failed!target url:{},message:{}", (Object)publisherRequest.getRequestUrl(), (Object)commonResponse.getMessage());
                throw new RuntimeException("PublishDataRequest get server response failed! msg:" + commonResponse.getMessage());
            }
        }
        catch (RequestException e) {
            LOGGER.error("DataNodeService register new publisher error! " + e.getRequestMessage(), (Throwable)e);
            throw new RuntimeException("DataNodeService register new publisher error! " + e.getRequestMessage(), e);
        }
    }

    @Override
    public void unregister(final Publisher publisher) {
        try {
            CommonResponse commonResponse;
            Request<UnPublishDataRequest> unPublishRequest = new Request<UnPublishDataRequest>(){
                private URL url;

                public UnPublishDataRequest getRequestBody() {
                    UnPublishDataRequest unPublishDataRequest = new UnPublishDataRequest();
                    unPublishDataRequest.setDataInfoId(publisher.getDataInfoId());
                    unPublishDataRequest.setRegisterId(publisher.getRegisterId());
                    unPublishDataRequest.setRegisterTimestamp(publisher.getRegisterTimestamp());
                    return unPublishDataRequest;
                }

                public URL getRequestUrl() {
                    if (this.url == null) {
                        this.url = DataNodeServiceImpl.this.getUrl(publisher.getDataInfoId());
                    }
                    return this.url;
                }
            };
            Response response = this.dataNodeExchanger.request((Request)unPublishRequest);
            Object result = response.getResult();
            if (result instanceof CommonResponse && !(commonResponse = (CommonResponse)result).isSuccess()) {
                LOGGER.error("UnPublishRequest get server response failed!target url:{},message:{}", (Object)unPublishRequest.getRequestUrl(), (Object)commonResponse.getMessage());
                throw new RuntimeException("UnPublishRequest get server response failed! msg:" + commonResponse.getMessage());
            }
        }
        catch (RequestException e) {
            LOGGER.error("Unregister publisher to data node error! " + e.getRequestMessage(), (Throwable)e);
            throw new RuntimeException("Unregister publisher to data node error! " + e.getRequestMessage(), e);
        }
    }

    @Override
    public void clientOff(final List<String> connectIds) {
        if (connectIds == null || connectIds.isEmpty()) {
            return;
        }
        Collection nodes = this.dataNodeManager.getDataCenterNodes();
        if (nodes != null && nodes.size() > 0) {
            for (final Node node : nodes) {
                Request<ClientOffRequest> clientOffRequestRequest = new Request<ClientOffRequest>(){
                    private AtomicInteger retryTimes = new AtomicInteger();

                    public ClientOffRequest getRequestBody() {
                        ClientOffRequest clientOffRequest = new ClientOffRequest();
                        clientOffRequest.setHosts(connectIds);
                        clientOffRequest.setGmtOccur(System.currentTimeMillis());
                        return clientOffRequest;
                    }

                    public URL getRequestUrl() {
                        return new URL(node.getNodeUrl().getIpAddress(), DataNodeServiceImpl.this.sessionServerConfig.getDataServerPort());
                    }

                    public AtomicInteger getRetryTimes() {
                        return this.retryTimes;
                    }
                };
                try {
                    Response response = this.dataNodeExchanger.request((Request)clientOffRequestRequest);
                    Object result = response.getResult();
                    if (result instanceof CommonResponse) {
                        CommonResponse commonResponse = (CommonResponse)result;
                        if (commonResponse.isSuccess()) continue;
                        LOGGER.error("ClientOff RequestRequest get response failed!target url:{},message:{}", (Object)node.getNodeUrl(), (Object)commonResponse.getMessage());
                        throw new RuntimeException("ClientOff RequestRequest get response failed! msg:" + commonResponse.getMessage());
                    }
                    LOGGER.error("ClientOff Request has not get response or response type illegal!url:{}", (Object)node.getNodeUrl());
                    throw new RuntimeException("ClientOff Request has not get response or response type illegal!");
                }
                catch (Exception e) {
                    LOGGER.error("Client Off request error! ", (Throwable)e);
                    this.clientOffRetry(clientOffRequestRequest);
                }
            }
        }
    }

    private void clientOffRetry(Request<ClientOffRequest> clientOffRequestRequest) {
        URL url = clientOffRequestRequest.getRequestUrl();
        int retryTimes = clientOffRequestRequest.getRetryTimes().incrementAndGet();
        if (retryTimes <= this.sessionServerConfig.getCancelDataTaskRetryTimes()) {
            this.asyncHashedWheelTimer.newTimeout(timeout -> {
                block4: {
                    try {
                        Response response = this.dataNodeExchanger.request(clientOffRequestRequest);
                        Object result = response.getResult();
                        if (result instanceof CommonResponse) {
                            CommonResponse commonResponse = (CommonResponse)result;
                            if (!commonResponse.isSuccess()) {
                                LOGGER.error("ClientOff retry RequestRequest get response failed!retryTimes={},target url:{},message:{}", new Object[]{retryTimes, url, commonResponse.getMessage()});
                                throw new RuntimeException("ClientOff retry RequestRequest get response failed! msg:" + commonResponse.getMessage());
                            }
                            break block4;
                        }
                        LOGGER.error("ClientOff retry Request has not get response or response type illegal!retryTimes={},url:{}", (Object)retryTimes, (Object)url);
                        throw new RuntimeException("ClientOff retry Request has not get response or response type illegal!");
                    }
                    catch (Exception e) {
                        this.clientOffRetry(clientOffRequestRequest);
                    }
                }
            }, this.getBlockTime(retryTimes), TimeUnit.MILLISECONDS);
        } else {
            LOGGER.error("ClientOff retryTimes have exceeded! stop retry! retryTimes={}, url={}, request={}", new Object[]{retryTimes, url, clientOffRequestRequest.getRequestBody()});
        }
    }

    private long getBlockTime(int retry) {
        long increment;
        long initialSleepTime = TimeUnit.MILLISECONDS.toMillis(this.sessionServerConfig.getCancelDataTaskRetryFirstDelay());
        long result = initialSleepTime + (increment = TimeUnit.MILLISECONDS.toMillis(this.sessionServerConfig.getCancelDataTaskRetryIncrementDelay())) * (long)(retry - 1);
        return result >= 0L ? result : 0L;
    }

    @Override
    public void registerSessionProcessId(final SessionServerRegisterRequest sessionServerRegisterRequest, final URL dataUrl) {
        try {
            Request<SessionServerRegisterRequest> request = new Request<SessionServerRegisterRequest>(){

                public SessionServerRegisterRequest getRequestBody() {
                    return sessionServerRegisterRequest;
                }

                public URL getRequestUrl() {
                    return dataUrl;
                }
            };
            this.dataNodeExchanger.request((Request)request);
        }
        catch (RequestException e) {
            LOGGER.error("DataNodeService register processId error! " + e.getRequestMessage(), (Throwable)e);
            throw new RuntimeException("DataNodeService register processId error! " + e.getRequestMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Map<String, Long>> fetchDataVersion(final URL dataNodeUrl, final Collection<String> dataInfoIdList) {
        Map<String, Map<String, Long>> map = new HashMap<String, Map<String, Long>>();
        try {
            Request<GetDataVersionRequest> getDataVersionRequestRequest = new Request<GetDataVersionRequest>(){

                public GetDataVersionRequest getRequestBody() {
                    GetDataVersionRequest getDataVersionRequest = new GetDataVersionRequest();
                    getDataVersionRequest.setDataInfoIds((List)dataInfoIdList);
                    return getDataVersionRequest;
                }

                public URL getRequestUrl() {
                    return dataNodeUrl;
                }
            };
            Response response = this.dataNodeExchanger.request((Request)getDataVersionRequestRequest);
            Object result = response.getResult();
            if (!(result instanceof GenericResponse)) {
                LOGGER.error("GetDataVersionRequestRequest has not get response or response type illegal!");
                return map;
            }
            GenericResponse genericResponse = (GenericResponse)result;
            if (genericResponse.isSuccess()) {
                map = (Map)genericResponse.getData();
                if (!map.isEmpty()) return map;
                LOGGER.warn("GetDataVersionRequestRequest get response contains no data!target data Node url:{} about dataInfoIds size:{}", (Object)dataNodeUrl.getAddressString(), (Object)dataInfoIdList.size());
                return map;
            }
            LOGGER.error("fetchDataVersion has not get fail response!msg:{}", (Object)genericResponse.getMessage());
            throw new RuntimeException("fetchDataVersion has not get fail response! msg:" + genericResponse.getMessage());
        }
        catch (RequestException e) {
            LOGGER.error("Fetch data Version request error! " + e.getRequestMessage(), (Throwable)e);
            throw new RuntimeException("Fetch data Version request error! " + e.getRequestMessage(), e);
        }
    }

    @Override
    public Datum fetchDataCenter(String dataInfoId, String dataCenterId) {
        Map<String, Datum> map = this.getDatumMap(dataInfoId, dataCenterId);
        if (map != null && map.size() > 0) {
            return map.get(dataCenterId);
        }
        return null;
    }

    @Override
    public Map<String, Datum> fetchGlobal(String dataInfoId) {
        return this.getDatumMap(dataInfoId);
    }

    private Map<String, Datum> getDatumMap(String dataInfoId) {
        return this.getDatumMap(dataInfoId, null);
    }

    @Override
    public Map<String, Datum> getDatumMap(final String dataInfoId, String dataCenterId) {
        Map map;
        block7: {
            try {
                final GetDataRequest getDataRequest = new GetDataRequest();
                if (dataCenterId != null) {
                    getDataRequest.setDataCenter(dataCenterId);
                }
                getDataRequest.setDataInfoId(dataInfoId);
                Request<GetDataRequest> getDataRequestStringRequest = new Request<GetDataRequest>(){

                    public GetDataRequest getRequestBody() {
                        return getDataRequest;
                    }

                    public URL getRequestUrl() {
                        return DataNodeServiceImpl.this.getUrl(dataInfoId);
                    }
                };
                Response response = this.dataNodeExchanger.request((Request)getDataRequestStringRequest);
                Object result = response.getResult();
                if (result instanceof GenericResponse) {
                    GenericResponse genericResponse = (GenericResponse)result;
                    if (genericResponse.isSuccess()) {
                        map = (Map)genericResponse.getData();
                        if (map == null || map.isEmpty()) {
                            LOGGER.warn("GetDataRequest get response contains no datum!");
                        } else {
                            map.forEach((dataCenter, datum) -> Datum.processDatum((Datum)datum));
                        }
                        break block7;
                    }
                    LOGGER.error("GetDataRequest has not get fail response!msg:{}", (Object)genericResponse.getMessage());
                    throw new RuntimeException("GetDataRequest has not get fail response! msg:" + genericResponse.getMessage());
                }
                LOGGER.error("GetDataRequest has not get response or response type illegal!");
                throw new RuntimeException("GetDataRequest has not get response or response type illegal!");
            }
            catch (RequestException e) {
                LOGGER.error("Get data request to data node error! " + e.getRequestMessage(), (Throwable)e);
                throw new RuntimeException("Get data request to data node error! " + e.getRequestMessage(), e);
            }
        }
        return map;
    }

    private URL getUrl(String dataInfoId) {
        Object dataNode = this.dataNodeManager.getNode(dataInfoId);
        if (dataNode != null) {
            String dataIp = dataNode.getNodeUrl().getIpAddress();
            return new URL(dataIp, this.sessionServerConfig.getDataServerPort());
        }
        return null;
    }
}

