/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.remoting;

import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.Client;
import com.alipay.sofa.registry.remoting.Server;
import com.alipay.sofa.registry.remoting.exchange.Exchange;
import com.alipay.sofa.registry.remoting.exchange.NodeExchanger;
import com.alipay.sofa.registry.remoting.exchange.RequestException;
import com.alipay.sofa.registry.remoting.exchange.message.Request;
import com.alipay.sofa.registry.remoting.exchange.message.Response;
import com.alipay.sofa.registry.server.session.bootstrap.SessionServerConfig;
import org.springframework.beans.factory.annotation.Autowired;

public class ClientNodeExchanger
implements NodeExchanger {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"SESSION-PUSH", (String)"[Exchange]");
    @Autowired
    private Exchange boltExchange;
    @Autowired
    private SessionServerConfig sessionServerConfig;

    public Response request(Request request) throws RequestException {
        Response response;
        block5: {
            response = null;
            try {
                URL url;
                Server sessionServer = this.boltExchange.getServer(Integer.valueOf(this.sessionServerConfig.getServerPort()));
                if (sessionServer == null || (url = request.getRequestUrl()) == null) break block5;
                Channel channel = sessionServer.getChannel(url);
                if (channel != null && channel.isConnected()) {
                    if (null != request.getCallBackHandler()) {
                        sessionServer.sendCallback(channel, request.getRequestBody(), request.getCallBackHandler(), this.sessionServerConfig.getClientNodeExchangeTimeOut());
                        response = () -> Response.ResultStatus.SUCCESSFUL;
                    } else {
                        Object result = sessionServer.sendSync(channel, request.getRequestBody(), this.sessionServerConfig.getClientNodeExchangeTimeOut());
                        response = () -> result;
                    }
                    break block5;
                }
                LOGGER.error("ClientNode Exchanger get channel {} error! Can't be null or disconnected!", (Object)url);
                throw new RequestException("ClientNode Exchanger get channel " + url + "error! Can't be null or disconnected!", request);
            }
            catch (Exception e) {
                throw new RequestException("ClientNode Exchanger request data error!", request, (Throwable)e);
            }
        }
        return response;
    }

    public Client connectServer() {
        return null;
    }
}

