/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.session.strategy.impl;

import com.alipay.sofa.registry.common.model.store.StoreData;
import com.alipay.sofa.registry.common.model.store.URL;
import com.alipay.sofa.registry.common.model.store.Watcher;
import com.alipay.sofa.registry.core.model.ConfiguratorRegister;
import com.alipay.sofa.registry.core.model.RegisterResponse;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.remoting.Channel;
import com.alipay.sofa.registry.remoting.bolt.BoltChannelUtil;
import com.alipay.sofa.registry.server.session.converter.SubscriberConverter;
import com.alipay.sofa.registry.server.session.registry.Registry;
import com.alipay.sofa.registry.server.session.strategy.WatcherHandlerStrategy;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultWatcherHandlerStrategy
implements WatcherHandlerStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWatcherHandlerStrategy.class);
    @Autowired
    private Registry sessionRegistry;

    @Override
    public void handleConfiguratorRegister(Channel channel, ConfiguratorRegister configuratorRegister, RegisterResponse registerResponse) {
        try {
            configuratorRegister.setIp(channel.getRemoteAddress().getAddress().getHostAddress());
            configuratorRegister.setPort(Integer.valueOf(channel.getRemoteAddress().getPort()));
            if (StringUtils.isBlank((String)configuratorRegister.getInstanceId())) {
                configuratorRegister.setInstanceId("DEFAULT_INSTANCE_ID");
            }
            Watcher watcher = SubscriberConverter.convert(configuratorRegister);
            watcher.setProcessId(channel.getRemoteAddress().getHostName() + ":" + channel.getRemoteAddress().getPort());
            watcher.setSourceAddress(new URL(channel.getRemoteAddress(), BoltChannelUtil.getBoltCustomSerializer((Channel)channel)));
            if ("REGISTER".equals(configuratorRegister.getEventType())) {
                this.sessionRegistry.register((StoreData<String>)watcher);
            } else if ("UNREGISTER".equals(configuratorRegister.getEventType())) {
                this.sessionRegistry.unRegister((StoreData<String>)watcher);
            }
            registerResponse.setVersion(configuratorRegister.getVersion().longValue());
            registerResponse.setRegistId(configuratorRegister.getRegistId());
            LOGGER.info("ConfiguratorRegister register success! {}", (Object)watcher);
            registerResponse.setSuccess(true);
            registerResponse.setMessage("ConfiguratorRegister register success!");
        }
        catch (Exception e) {
            LOGGER.error("ConfiguratorRegister register error!", (Throwable)e);
            registerResponse.setSuccess(false);
            registerResponse.setMessage("ConfiguratorRegister register failed!");
        }
    }
}

