/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.runtime.adapter;

import com.alipay.sofa.rpc.boot.container.SpringBridge;
import com.alipay.sofa.rpc.boot.runtime.binding.RpcBinding;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.rpc.registry.RegistryFactory;
import com.alipay.sofa.runtime.api.ServiceRuntimeException;
import com.alipay.sofa.runtime.spi.binding.Binding;
import com.alipay.sofa.runtime.spi.binding.BindingAdapter;
import com.alipay.sofa.runtime.spi.binding.Contract;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import java.util.List;

public abstract class RpcBindingAdapter
implements BindingAdapter<RpcBinding> {
    public void preOutBinding(Object contract, RpcBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
        String uniqueName = SpringBridge.getProviderConfigContainer().createUniqueName((Contract)contract, binding);
        ProviderConfig providerConfig = SpringBridge.getProviderConfigHelper().getProviderConfig((Contract)contract, binding, target);
        try {
            SpringBridge.getProviderConfigContainer().addProviderConfig(uniqueName, providerConfig);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"02104"), (Throwable)e);
        }
    }

    public Object outBinding(Object contract, RpcBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
        String uniqueName = SpringBridge.getProviderConfigContainer().createUniqueName((Contract)contract, binding);
        ProviderConfig providerConfig = SpringBridge.getProviderConfigContainer().getProviderConfig(uniqueName);
        if (providerConfig == null) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"00304", (Object[])new Object[]{uniqueName}));
        }
        try {
            providerConfig.export();
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"02104"), (Throwable)e);
        }
        if (SpringBridge.getProviderConfigContainer().isAllowPublish()) {
            providerConfig.setRegister(true);
            List registrys = providerConfig.getRegistry();
            for (RegistryConfig registryConfig : registrys) {
                Registry registry = RegistryFactory.getRegistry((RegistryConfig)registryConfig);
                registry.init();
                registry.start();
                registry.register(providerConfig);
            }
        }
        return Boolean.TRUE;
    }

    public void preUnoutBinding(Object contract, RpcBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
        ProviderConfig providerConfig = SpringBridge.getProviderConfigHelper().getProviderConfig((Contract)contract, binding, target);
        try {
            providerConfig.unExport();
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"02105"), (Throwable)e);
        }
    }

    public void postUnoutBinding(Object contract, RpcBinding binding, Object target, SofaRuntimeContext sofaRuntimeContext) {
        ProviderConfig metadata = SpringBridge.getProviderConfigHelper().getProviderConfig((Contract)contract, binding, target);
        try {
            String key = SpringBridge.getProviderConfigContainer().createUniqueName((Contract)contract, binding);
            List servers = SpringBridge.getProviderConfigContainer().getProviderConfig(key).getServer();
            for (ServerConfig server : servers) {
                server.getServer().unRegisterProcessor(metadata, false);
            }
            SpringBridge.getProviderConfigContainer().removeProviderConfig(key);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"02106"), (Throwable)e);
        }
    }

    public Object inBinding(Object contract, RpcBinding binding, SofaRuntimeContext sofaRuntimeContext) {
        ConsumerConfig consumerConfig = SpringBridge.getConsumerConfigHelper().getConsumerConfig((Contract)contract, binding);
        SpringBridge.getConsumerConfigContainer().addConsumerConfig((Binding)binding, consumerConfig);
        try {
            Object result = consumerConfig.refer();
            binding.setConsumerConfig(consumerConfig);
            return result;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"02103"), (Throwable)e);
        }
    }

    public void unInBinding(Object contract, RpcBinding binding, SofaRuntimeContext sofaRuntimeContext) {
        try {
            SpringBridge.getConsumerConfigContainer().removeAndUnReferConsumerConfig((Binding)binding);
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(LogCodes.getLog((String)"02424"), (Throwable)e);
        }
    }

    public Class<RpcBinding> getBindingClass() {
        return RpcBinding.class;
    }
}

