/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.common;

import com.alipay.sofa.rpc.common.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class RegistryParseUtil {
    public static String parseAddress(String config, String protocol) {
        String address = null;
        if (StringUtils.isNotEmpty((CharSequence)config) && config.startsWith(protocol)) {
            String nacosProtocol = protocol + "://";
            String value = config.substring(nacosProtocol.length());
            if (!value.contains("?")) {
                address = value;
            } else {
                int index = value.lastIndexOf(63);
                address = value.substring(0, index);
            }
        }
        return address;
    }

    public static Map<String, String> parseParam(String address, String protocol) {
        String host = RegistryParseUtil.parseAddress(address, protocol);
        String paramString = address.substring(address.indexOf(host) + host.length());
        if (StringUtils.isNotEmpty((CharSequence)paramString) && paramString.startsWith("?")) {
            paramString = paramString.substring(1);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (paramString.contains("&")) {
            String[] paramSplit;
            for (String param : paramSplit = paramString.split("&")) {
                Map<String, String> tempMap = RegistryParseUtil.parseKeyValue(param);
                map.putAll(tempMap);
            }
        } else {
            Map<String, String> tempMap = RegistryParseUtil.parseKeyValue(paramString);
            map.putAll(tempMap);
        }
        return map;
    }

    public static Map<String, String> parseKeyValue(String kv) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)kv)) {
            String[] kvSplit = kv.split("=");
            String key = kvSplit[0];
            String value = kvSplit[1];
            map.put(key, value);
        }
        return map;
    }
}

