/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.boot.config;

import com.alipay.sofa.rpc.boot.common.SofaBootRpcParserUtil;
import com.alipay.sofa.rpc.boot.config.SofaBootRpcProperties;
import com.alipay.sofa.rpc.client.aft.FaultToleranceConfig;
import com.alipay.sofa.rpc.client.aft.FaultToleranceConfigManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class FaultToleranceConfigurator {
    @Autowired
    private SofaBootRpcProperties sofaBootRpcProperties;
    @Value(value="${spring.application.name}")
    private String appName;

    public void startFaultTolerance() {
        String regulationEffectiveStr = this.sofaBootRpcProperties.getAftRegulationEffective();
        String degradeEffectiveStr = this.sofaBootRpcProperties.getAftDegradeEffective();
        String timeWindowStr = this.sofaBootRpcProperties.getAftTimeWindow();
        String leastWindowCountStr = this.sofaBootRpcProperties.getAftLeastWindowCount();
        String leastWindowExceptionRateMultipleStr = this.sofaBootRpcProperties.getAftLeastWindowExceptionRateMultiple();
        String weightDegradeRateStr = this.sofaBootRpcProperties.getAftWeightDegradeRate();
        String weightRecoverRateStr = this.sofaBootRpcProperties.getAftWeightRecoverRate();
        String degradeLeastWeightStr = this.sofaBootRpcProperties.getAftDegradeLeastWeight();
        String degradeMaxIpCountStr = this.sofaBootRpcProperties.getAftDegradeMaxIpCount();
        Boolean regulationEffective = SofaBootRpcParserUtil.parseBoolean(regulationEffectiveStr);
        Boolean degradeEffective = SofaBootRpcParserUtil.parseBoolean(degradeEffectiveStr);
        Long timeWindow = SofaBootRpcParserUtil.parseLong(timeWindowStr);
        Long leastWindowCount = SofaBootRpcParserUtil.parseLong(leastWindowCountStr);
        Double leastWindowExceptionRateMultiple = SofaBootRpcParserUtil.parseDouble(leastWindowExceptionRateMultipleStr);
        Double weightDegradeRate = SofaBootRpcParserUtil.parseDouble(weightDegradeRateStr);
        Double weightRecoverRate = SofaBootRpcParserUtil.parseDouble(weightRecoverRateStr);
        Integer degradeLeastWeight = SofaBootRpcParserUtil.parseInteger(degradeLeastWeightStr);
        Integer degradeMaxIpCount = SofaBootRpcParserUtil.parseInteger(degradeMaxIpCountStr);
        FaultToleranceConfig faultToleranceConfig = new FaultToleranceConfig();
        if (regulationEffective != null) {
            faultToleranceConfig.setRegulationEffective(regulationEffective.booleanValue());
        }
        if (degradeEffective != null) {
            faultToleranceConfig.setDegradeEffective(degradeEffective.booleanValue());
        }
        if (timeWindow != null) {
            faultToleranceConfig.setTimeWindow(timeWindow.longValue());
        }
        if (leastWindowCount != null) {
            faultToleranceConfig.setLeastWindowCount(leastWindowCount.longValue());
        }
        if (leastWindowExceptionRateMultiple != null) {
            faultToleranceConfig.setLeastWindowExceptionRateMultiple(leastWindowExceptionRateMultiple.doubleValue());
        }
        if (weightDegradeRate != null) {
            faultToleranceConfig.setWeightDegradeRate(weightDegradeRate.doubleValue());
        }
        if (weightRecoverRate != null) {
            faultToleranceConfig.setWeightRecoverRate(weightRecoverRate.doubleValue());
        }
        if (degradeLeastWeight != null) {
            faultToleranceConfig.setDegradeLeastWeight(degradeLeastWeight.intValue());
        }
        if (degradeMaxIpCount != null) {
            faultToleranceConfig.setDegradeMaxIpCount(degradeMaxIpCount.intValue());
        }
        FaultToleranceConfigManager.putAppConfig((String)this.appName, (FaultToleranceConfig)faultToleranceConfig);
    }
}

