/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.autoconfigure.tracer;

import com.alipay.sofa.boot.autoconfigure.tracer.SofaTracerAutoConfiguration;
import com.alipay.sofa.tracer.boot.flexible.aop.SofaTracerAdvisingBeanPostProcessor;
import com.alipay.sofa.tracer.boot.flexible.processor.MethodInvocationProcessor;
import com.alipay.sofa.tracer.boot.flexible.processor.SofaTracerIntroductionInterceptor;
import com.alipay.sofa.tracer.boot.flexible.processor.SofaTracerMethodInvocationProcessor;
import io.opentracing.Tracer;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="com.alipay.sofa.tracer.flexible", value={"enable"}, matchIfMissing=true)
@AutoConfigureAfter(value={SofaTracerAutoConfiguration.class})
@ConditionalOnBean(value={Tracer.class})
@ConditionalOnClass(value={SofaTracerIntroductionInterceptor.class})
public class TracerAnnotationAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    MethodInvocationProcessor sofaMethodInvocationProcessor(Tracer tracer) {
        return new SofaTracerMethodInvocationProcessor(tracer);
    }

    @Bean
    @ConditionalOnMissingBean
    SofaTracerIntroductionInterceptor sofaTracerIntroductionInterceptor(MethodInvocationProcessor methodInvocationProcessor) {
        return new SofaTracerIntroductionInterceptor(methodInvocationProcessor);
    }

    @Bean
    @ConditionalOnMissingBean
    SofaTracerAdvisingBeanPostProcessor tracerAnnotationBeanPostProcessor(SofaTracerIntroductionInterceptor methodInterceptor) {
        return new SofaTracerAdvisingBeanPostProcessor((MethodInterceptor)methodInterceptor);
    }
}

