/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.util;

import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class BeanDefinitionUtil {
    public static Class<?> resolveBeanClassType(BeanDefinition beanDefinition) {
        Class clazz = null;
        if (beanDefinition instanceof AnnotatedBeanDefinition) {
            String className;
            if (BeanDefinitionUtil.isFromConfigurationSource(beanDefinition)) {
                MethodMetadata methodMetadata = ((AnnotatedBeanDefinition)beanDefinition).getFactoryMethodMetadata();
                className = methodMetadata.getReturnTypeName();
            } else {
                AnnotationMetadata annotationMetadata = ((AnnotatedBeanDefinition)beanDefinition).getMetadata();
                className = annotationMetadata.getClassName();
            }
            try {
                clazz = StringUtils.isEmpty((Object)className) ? null : ClassUtils.forName((String)className, null);
            }
            catch (Throwable annotationMetadata) {
                // empty catch block
            }
        }
        if (clazz == null) {
            try {
                clazz = ((AbstractBeanDefinition)beanDefinition).getBeanClass();
            }
            catch (IllegalStateException ex) {
                try {
                    String className = beanDefinition.getBeanClassName();
                    clazz = StringUtils.isEmpty((Object)className) ? null : ClassUtils.forName((String)className, null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (ClassUtils.isCglibProxyClass(clazz)) {
            return clazz.getSuperclass();
        }
        return clazz;
    }

    public static boolean isFromConfigurationSource(BeanDefinition beanDefinition) {
        return beanDefinition.getClass().getCanonicalName().startsWith("org.springframework.context.annotation.ConfigurationClassBeanDefinitionReader");
    }
}

