/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.chatbot20220408.models;

import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class AssociateRequest
extends Request {
    @Host
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="AgentKey")
    private String agentKey;
    @Query
    @NameInMap(value="InstanceId")
    private String instanceId;
    @Query
    @NameInMap(value="Perspective")
    private List<String> perspective;
    @Query
    @NameInMap(value="RecommendNum")
    private Long recommendNum;
    @Query
    @NameInMap(value="SessionId")
    private String sessionId;
    @Query
    @NameInMap(value="Utterance")
    private String utterance;

    private AssociateRequest(Builder builder) {
        super((Request.Builder)builder);
        this.regionId = builder.regionId;
        this.agentKey = builder.agentKey;
        this.instanceId = builder.instanceId;
        this.perspective = builder.perspective;
        this.recommendNum = builder.recommendNum;
        this.sessionId = builder.sessionId;
        this.utterance = builder.utterance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static AssociateRequest create() {
        return AssociateRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getAgentKey() {
        return this.agentKey;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public List<String> getPerspective() {
        return this.perspective;
    }

    public Long getRecommendNum() {
        return this.recommendNum;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getUtterance() {
        return this.utterance;
    }

    public static final class Builder
    extends Request.Builder<AssociateRequest, Builder> {
        private String regionId;
        private String agentKey;
        private String instanceId;
        private List<String> perspective;
        private Long recommendNum;
        private String sessionId;
        private String utterance;

        private Builder() {
        }

        private Builder(AssociateRequest request) {
            super((Request)request);
            this.regionId = request.regionId;
            this.agentKey = request.agentKey;
            this.instanceId = request.instanceId;
            this.perspective = request.perspective;
            this.recommendNum = request.recommendNum;
            this.sessionId = request.sessionId;
            this.utterance = request.utterance;
        }

        public Builder regionId(String regionId) {
            this.putHostParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder agentKey(String agentKey) {
            this.putQueryParameter("AgentKey", agentKey);
            this.agentKey = agentKey;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder perspective(List<String> perspective) {
            String perspectiveShrink = this.shrink(perspective, "Perspective", "json");
            this.putQueryParameter("Perspective", perspectiveShrink);
            this.perspective = perspective;
            return this;
        }

        public Builder recommendNum(Long recommendNum) {
            this.putQueryParameter("RecommendNum", recommendNum);
            this.recommendNum = recommendNum;
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.putQueryParameter("SessionId", sessionId);
            this.sessionId = sessionId;
            return this;
        }

        public Builder utterance(String utterance) {
            this.putQueryParameter("Utterance", utterance);
            this.utterance = utterance;
            return this;
        }

        public AssociateRequest build() {
            return new AssociateRequest(this);
        }
    }
}

