/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.chatbot20220408.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class ChatRequest
extends Request {
    @Query
    @NameInMap(value="AgentKey")
    private String agentKey;
    @Query
    @NameInMap(value="InstanceId")
    private String instanceId;
    @Query
    @NameInMap(value="IntentName")
    private String intentName;
    @Query
    @NameInMap(value="KnowledgeId")
    private String knowledgeId;
    @Query
    @NameInMap(value="Perspective")
    private List<String> perspective;
    @Query
    @NameInMap(value="SenderId")
    private String senderId;
    @Query
    @NameInMap(value="SenderNick")
    private String senderNick;
    @Query
    @NameInMap(value="SessionId")
    private String sessionId;
    @Query
    @NameInMap(value="Utterance")
    private String utterance;
    @Query
    @NameInMap(value="VendorParam")
    private String vendorParam;

    private ChatRequest(Builder builder) {
        super((Request.Builder)builder);
        this.agentKey = builder.agentKey;
        this.instanceId = builder.instanceId;
        this.intentName = builder.intentName;
        this.knowledgeId = builder.knowledgeId;
        this.perspective = builder.perspective;
        this.senderId = builder.senderId;
        this.senderNick = builder.senderNick;
        this.sessionId = builder.sessionId;
        this.utterance = builder.utterance;
        this.vendorParam = builder.vendorParam;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ChatRequest create() {
        return ChatRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAgentKey() {
        return this.agentKey;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getIntentName() {
        return this.intentName;
    }

    public String getKnowledgeId() {
        return this.knowledgeId;
    }

    public List<String> getPerspective() {
        return this.perspective;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public String getSenderNick() {
        return this.senderNick;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getUtterance() {
        return this.utterance;
    }

    public String getVendorParam() {
        return this.vendorParam;
    }

    public static final class Builder
    extends Request.Builder<ChatRequest, Builder> {
        private String agentKey;
        private String instanceId;
        private String intentName;
        private String knowledgeId;
        private List<String> perspective;
        private String senderId;
        private String senderNick;
        private String sessionId;
        private String utterance;
        private String vendorParam;

        private Builder() {
        }

        private Builder(ChatRequest request) {
            super((Request)request);
            this.agentKey = request.agentKey;
            this.instanceId = request.instanceId;
            this.intentName = request.intentName;
            this.knowledgeId = request.knowledgeId;
            this.perspective = request.perspective;
            this.senderId = request.senderId;
            this.senderNick = request.senderNick;
            this.sessionId = request.sessionId;
            this.utterance = request.utterance;
            this.vendorParam = request.vendorParam;
        }

        public Builder agentKey(String agentKey) {
            this.putQueryParameter("AgentKey", agentKey);
            this.agentKey = agentKey;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder intentName(String intentName) {
            this.putQueryParameter("IntentName", intentName);
            this.intentName = intentName;
            return this;
        }

        public Builder knowledgeId(String knowledgeId) {
            this.putQueryParameter("KnowledgeId", knowledgeId);
            this.knowledgeId = knowledgeId;
            return this;
        }

        public Builder perspective(List<String> perspective) {
            String perspectiveShrink = this.shrink(perspective, "Perspective", "json");
            this.putQueryParameter("Perspective", perspectiveShrink);
            this.perspective = perspective;
            return this;
        }

        public Builder senderId(String senderId) {
            this.putQueryParameter("SenderId", senderId);
            this.senderId = senderId;
            return this;
        }

        public Builder senderNick(String senderNick) {
            this.putQueryParameter("SenderNick", senderNick);
            this.senderNick = senderNick;
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.putQueryParameter("SessionId", sessionId);
            this.sessionId = sessionId;
            return this;
        }

        public Builder utterance(String utterance) {
            this.putQueryParameter("Utterance", utterance);
            this.utterance = utterance;
            return this;
        }

        public Builder vendorParam(String vendorParam) {
            this.putQueryParameter("VendorParam", vendorParam);
            this.vendorParam = vendorParam;
            return this;
        }

        public ChatRequest build() {
            return new ChatRequest(this);
        }
    }
}

