/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.chatbot20220408.models;

import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class CreateIntentRequest
extends Request {
    @Host
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="AgentKey")
    private String agentKey;
    @Query
    @NameInMap(value="InstanceId")
    @Validation(required=true)
    private String instanceId;
    @Query
    @NameInMap(value="IntentDefinition")
    private IntentDefinition intentDefinition;

    private CreateIntentRequest(Builder builder) {
        super((Request.Builder)builder);
        this.regionId = builder.regionId;
        this.agentKey = builder.agentKey;
        this.instanceId = builder.instanceId;
        this.intentDefinition = builder.intentDefinition;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateIntentRequest create() {
        return CreateIntentRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getAgentKey() {
        return this.agentKey;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public IntentDefinition getIntentDefinition() {
        return this.intentDefinition;
    }

    public static class IntentDefinition
    extends TeaModel {
        @NameInMap(value="AliasName")
        private String aliasName;
        @NameInMap(value="IntentName")
        @Validation(required=true)
        private String intentName;
        @NameInMap(value="SlotInfos")
        private List<SlotInfos> slotInfos;

        private IntentDefinition(Builder builder) {
            this.aliasName = builder.aliasName;
            this.intentName = builder.intentName;
            this.slotInfos = builder.slotInfos;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static IntentDefinition create() {
            return IntentDefinition.builder().build();
        }

        public String getAliasName() {
            return this.aliasName;
        }

        public String getIntentName() {
            return this.intentName;
        }

        public List<SlotInfos> getSlotInfos() {
            return this.slotInfos;
        }

        public static final class Builder {
            private String aliasName;
            private String intentName;
            private List<SlotInfos> slotInfos;

            public Builder aliasName(String aliasName) {
                this.aliasName = aliasName;
                return this;
            }

            public Builder intentName(String intentName) {
                this.intentName = intentName;
                return this;
            }

            public Builder slotInfos(List<SlotInfos> slotInfos) {
                this.slotInfos = slotInfos;
                return this;
            }

            public IntentDefinition build() {
                return new IntentDefinition(this);
            }
        }
    }

    public static class SlotInfos
    extends TeaModel {
        @NameInMap(value="Array")
        private Boolean array;
        @NameInMap(value="Encrypt")
        private Boolean encrypt;
        @NameInMap(value="Interactive")
        private Boolean interactive;
        @NameInMap(value="Name")
        @Validation(required=true)
        private String name;
        @NameInMap(value="SlotId")
        @Validation(required=true)
        private String slotId;
        @NameInMap(value="Value")
        @Validation(required=true)
        private String value;

        private SlotInfos(Builder builder) {
            this.array = builder.array;
            this.encrypt = builder.encrypt;
            this.interactive = builder.interactive;
            this.name = builder.name;
            this.slotId = builder.slotId;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static SlotInfos create() {
            return SlotInfos.builder().build();
        }

        public Boolean getArray() {
            return this.array;
        }

        public Boolean getEncrypt() {
            return this.encrypt;
        }

        public Boolean getInteractive() {
            return this.interactive;
        }

        public String getName() {
            return this.name;
        }

        public String getSlotId() {
            return this.slotId;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private Boolean array;
            private Boolean encrypt;
            private Boolean interactive;
            private String name;
            private String slotId;
            private String value;

            public Builder array(Boolean array) {
                this.array = array;
                return this;
            }

            public Builder encrypt(Boolean encrypt) {
                this.encrypt = encrypt;
                return this;
            }

            public Builder interactive(Boolean interactive) {
                this.interactive = interactive;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder slotId(String slotId) {
                this.slotId = slotId;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public SlotInfos build() {
                return new SlotInfos(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreateIntentRequest, Builder> {
        private String regionId;
        private String agentKey;
        private String instanceId;
        private IntentDefinition intentDefinition;

        private Builder() {
        }

        private Builder(CreateIntentRequest request) {
            super((Request)request);
            this.regionId = request.regionId;
            this.agentKey = request.agentKey;
            this.instanceId = request.instanceId;
            this.intentDefinition = request.intentDefinition;
        }

        public Builder regionId(String regionId) {
            this.putHostParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder agentKey(String agentKey) {
            this.putQueryParameter("AgentKey", agentKey);
            this.agentKey = agentKey;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder intentDefinition(IntentDefinition intentDefinition) {
            String intentDefinitionShrink = this.shrink((Object)intentDefinition, "IntentDefinition", "json");
            this.putQueryParameter("IntentDefinition", intentDefinitionShrink);
            this.intentDefinition = intentDefinition;
            return this;
        }

        public CreateIntentRequest build() {
            return new CreateIntentRequest(this);
        }
    }
}

