/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.chatbot20220408.models;

import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import java.util.List;

public class CreateSolutionRequest
extends Request {
    @Host
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="AgentKey")
    private String agentKey;
    @Query
    @NameInMap(value="Content")
    @Validation(required=true)
    private String content;
    @Query
    @NameInMap(value="ContentType")
    private Integer contentType;
    @Query
    @NameInMap(value="KnowledgeId")
    @Validation(required=true)
    private Long knowledgeId;
    @Query
    @NameInMap(value="PerspectiveCodes")
    @Validation(required=true)
    private List<String> perspectiveCodes;

    private CreateSolutionRequest(Builder builder) {
        super((Request.Builder)builder);
        this.regionId = builder.regionId;
        this.agentKey = builder.agentKey;
        this.content = builder.content;
        this.contentType = builder.contentType;
        this.knowledgeId = builder.knowledgeId;
        this.perspectiveCodes = builder.perspectiveCodes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateSolutionRequest create() {
        return CreateSolutionRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getAgentKey() {
        return this.agentKey;
    }

    public String getContent() {
        return this.content;
    }

    public Integer getContentType() {
        return this.contentType;
    }

    public Long getKnowledgeId() {
        return this.knowledgeId;
    }

    public List<String> getPerspectiveCodes() {
        return this.perspectiveCodes;
    }

    public static final class Builder
    extends Request.Builder<CreateSolutionRequest, Builder> {
        private String regionId;
        private String agentKey;
        private String content;
        private Integer contentType;
        private Long knowledgeId;
        private List<String> perspectiveCodes;

        private Builder() {
        }

        private Builder(CreateSolutionRequest request) {
            super((Request)request);
            this.regionId = request.regionId;
            this.agentKey = request.agentKey;
            this.content = request.content;
            this.contentType = request.contentType;
            this.knowledgeId = request.knowledgeId;
            this.perspectiveCodes = request.perspectiveCodes;
        }

        public Builder regionId(String regionId) {
            this.putHostParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder agentKey(String agentKey) {
            this.putQueryParameter("AgentKey", agentKey);
            this.agentKey = agentKey;
            return this;
        }

        public Builder content(String content) {
            this.putQueryParameter("Content", content);
            this.content = content;
            return this;
        }

        public Builder contentType(Integer contentType) {
            this.putQueryParameter("ContentType", contentType);
            this.contentType = contentType;
            return this;
        }

        public Builder knowledgeId(Long knowledgeId) {
            this.putQueryParameter("KnowledgeId", knowledgeId);
            this.knowledgeId = knowledgeId;
            return this;
        }

        public Builder perspectiveCodes(List<String> perspectiveCodes) {
            this.putQueryParameter("PerspectiveCodes", perspectiveCodes);
            this.perspectiveCodes = perspectiveCodes;
            return this;
        }

        public CreateSolutionRequest build() {
            return new CreateSolutionRequest(this);
        }
    }
}

