/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.chatbot20220408.models;

import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class CreateUserSayRequest
extends Request {
    @Host
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="AgentKey")
    private String agentKey;
    @Query
    @NameInMap(value="InstanceId")
    @Validation(required=true)
    private String instanceId;
    @Query
    @NameInMap(value="UserSayDefinition")
    private UserSayDefinition userSayDefinition;

    private CreateUserSayRequest(Builder builder) {
        super((Request.Builder)builder);
        this.regionId = builder.regionId;
        this.agentKey = builder.agentKey;
        this.instanceId = builder.instanceId;
        this.userSayDefinition = builder.userSayDefinition;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateUserSayRequest create() {
        return CreateUserSayRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getAgentKey() {
        return this.agentKey;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public UserSayDefinition getUserSayDefinition() {
        return this.userSayDefinition;
    }

    public static class UserSayDefinition
    extends TeaModel {
        @NameInMap(value="Content")
        @Validation(required=true)
        private String content;
        @NameInMap(value="IntentId")
        @Validation(required=true)
        private Long intentId;
        @NameInMap(value="SlotInfos")
        private List<SlotInfos> slotInfos;

        private UserSayDefinition(Builder builder) {
            this.content = builder.content;
            this.intentId = builder.intentId;
            this.slotInfos = builder.slotInfos;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static UserSayDefinition create() {
            return UserSayDefinition.builder().build();
        }

        public String getContent() {
            return this.content;
        }

        public Long getIntentId() {
            return this.intentId;
        }

        public List<SlotInfos> getSlotInfos() {
            return this.slotInfos;
        }

        public static final class Builder {
            private String content;
            private Long intentId;
            private List<SlotInfos> slotInfos;

            public Builder content(String content) {
                this.content = content;
                return this;
            }

            public Builder intentId(Long intentId) {
                this.intentId = intentId;
                return this;
            }

            public Builder slotInfos(List<SlotInfos> slotInfos) {
                this.slotInfos = slotInfos;
                return this;
            }

            public UserSayDefinition build() {
                return new UserSayDefinition(this);
            }
        }
    }

    public static class SlotInfos
    extends TeaModel {
        @NameInMap(value="EndIndex")
        private Integer endIndex;
        @NameInMap(value="SlotId")
        private String slotId;
        @NameInMap(value="StartIndex")
        private Integer startIndex;

        private SlotInfos(Builder builder) {
            this.endIndex = builder.endIndex;
            this.slotId = builder.slotId;
            this.startIndex = builder.startIndex;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static SlotInfos create() {
            return SlotInfos.builder().build();
        }

        public Integer getEndIndex() {
            return this.endIndex;
        }

        public String getSlotId() {
            return this.slotId;
        }

        public Integer getStartIndex() {
            return this.startIndex;
        }

        public static final class Builder {
            private Integer endIndex;
            private String slotId;
            private Integer startIndex;

            public Builder endIndex(Integer endIndex) {
                this.endIndex = endIndex;
                return this;
            }

            public Builder slotId(String slotId) {
                this.slotId = slotId;
                return this;
            }

            public Builder startIndex(Integer startIndex) {
                this.startIndex = startIndex;
                return this;
            }

            public SlotInfos build() {
                return new SlotInfos(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreateUserSayRequest, Builder> {
        private String regionId;
        private String agentKey;
        private String instanceId;
        private UserSayDefinition userSayDefinition;

        private Builder() {
        }

        private Builder(CreateUserSayRequest request) {
            super((Request)request);
            this.regionId = request.regionId;
            this.agentKey = request.agentKey;
            this.instanceId = request.instanceId;
            this.userSayDefinition = request.userSayDefinition;
        }

        public Builder regionId(String regionId) {
            this.putHostParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder agentKey(String agentKey) {
            this.putQueryParameter("AgentKey", agentKey);
            this.agentKey = agentKey;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder userSayDefinition(UserSayDefinition userSayDefinition) {
            String userSayDefinitionShrink = this.shrink((Object)userSayDefinition, "UserSayDefinition", "json");
            this.putQueryParameter("UserSayDefinition", userSayDefinitionShrink);
            this.userSayDefinition = userSayDefinition;
            return this;
        }

        public CreateUserSayRequest build() {
            return new CreateUserSayRequest(this);
        }
    }
}

