/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.chatbot20220408.models;

import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class InitIMConnectRequest
extends Request {
    @Host
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="AgentKey")
    private String agentKey;
    @Query
    @NameInMap(value="From")
    @Validation(required=true)
    private String from;
    @Query
    @NameInMap(value="UserAccessToken")
    private String userAccessToken;

    private InitIMConnectRequest(Builder builder) {
        super((Request.Builder)builder);
        this.regionId = builder.regionId;
        this.agentKey = builder.agentKey;
        this.from = builder.from;
        this.userAccessToken = builder.userAccessToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static InitIMConnectRequest create() {
        return InitIMConnectRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getAgentKey() {
        return this.agentKey;
    }

    public String getFrom() {
        return this.from;
    }

    public String getUserAccessToken() {
        return this.userAccessToken;
    }

    public static final class Builder
    extends Request.Builder<InitIMConnectRequest, Builder> {
        private String regionId;
        private String agentKey;
        private String from;
        private String userAccessToken;

        private Builder() {
        }

        private Builder(InitIMConnectRequest request) {
            super((Request)request);
            this.regionId = request.regionId;
            this.agentKey = request.agentKey;
            this.from = request.from;
            this.userAccessToken = request.userAccessToken;
        }

        public Builder regionId(String regionId) {
            this.putHostParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder agentKey(String agentKey) {
            this.putQueryParameter("AgentKey", agentKey);
            this.agentKey = agentKey;
            return this;
        }

        public Builder from(String from) {
            this.putQueryParameter("From", from);
            this.from = from;
            return this;
        }

        public Builder userAccessToken(String userAccessToken) {
            this.putQueryParameter("UserAccessToken", userAccessToken);
            this.userAccessToken = userAccessToken;
            return this;
        }

        public InitIMConnectRequest build() {
            return new InitIMConnectRequest(this);
        }
    }
}

