/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.chatbot20220408.models;

import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ListIntentRequest
extends Request {
    @Host
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="AgentKey")
    private String agentKey;
    @Query
    @NameInMap(value="InstanceId")
    @Validation(required=true)
    private String instanceId;
    @Query
    @NameInMap(value="IntentName")
    private String intentName;
    @Query
    @NameInMap(value="PageNumber")
    @Validation(maximum=999999.0, minimum=1.0)
    private Integer pageNumber;
    @Query
    @NameInMap(value="PageSize")
    @Validation(maximum=1000.0, minimum=1.0)
    private Integer pageSize;

    private ListIntentRequest(Builder builder) {
        super((Request.Builder)builder);
        this.regionId = builder.regionId;
        this.agentKey = builder.agentKey;
        this.instanceId = builder.instanceId;
        this.intentName = builder.intentName;
        this.pageNumber = builder.pageNumber;
        this.pageSize = builder.pageSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListIntentRequest create() {
        return ListIntentRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getAgentKey() {
        return this.agentKey;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getIntentName() {
        return this.intentName;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public static final class Builder
    extends Request.Builder<ListIntentRequest, Builder> {
        private String regionId;
        private String agentKey;
        private String instanceId;
        private String intentName;
        private Integer pageNumber;
        private Integer pageSize;

        private Builder() {
        }

        private Builder(ListIntentRequest request) {
            super((Request)request);
            this.regionId = request.regionId;
            this.agentKey = request.agentKey;
            this.instanceId = request.instanceId;
            this.intentName = request.intentName;
            this.pageNumber = request.pageNumber;
            this.pageSize = request.pageSize;
        }

        public Builder regionId(String regionId) {
            this.putHostParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder agentKey(String agentKey) {
            this.putQueryParameter("AgentKey", agentKey);
            this.agentKey = agentKey;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder intentName(String intentName) {
            this.putQueryParameter("IntentName", intentName);
            this.intentName = intentName;
            return this;
        }

        public Builder pageNumber(Integer pageNumber) {
            this.putQueryParameter("PageNumber", pageNumber);
            this.pageNumber = pageNumber;
            return this;
        }

        public Builder pageSize(Integer pageSize) {
            this.putQueryParameter("PageSize", pageSize);
            this.pageSize = pageSize;
            return this;
        }

        public ListIntentRequest build() {
            return new ListIntentRequest(this);
        }
    }
}

