/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.chatbot20220408.models;

import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;

public class UpdateLgfRequest
extends Request {
    @Host
    @NameInMap(value="RegionId")
    private String regionId;
    @Query
    @NameInMap(value="AgentKey")
    private String agentKey;
    @Query
    @NameInMap(value="InstanceId")
    @Validation(required=true)
    private String instanceId;
    @Query
    @NameInMap(value="LgfDefinition")
    @Validation(required=true)
    private LgfDefinition lgfDefinition;
    @Query
    @NameInMap(value="LgfId")
    @Validation(required=true)
    private Long lgfId;

    private UpdateLgfRequest(Builder builder) {
        super((Request.Builder)builder);
        this.regionId = builder.regionId;
        this.agentKey = builder.agentKey;
        this.instanceId = builder.instanceId;
        this.lgfDefinition = builder.lgfDefinition;
        this.lgfId = builder.lgfId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UpdateLgfRequest create() {
        return UpdateLgfRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getAgentKey() {
        return this.agentKey;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public LgfDefinition getLgfDefinition() {
        return this.lgfDefinition;
    }

    public Long getLgfId() {
        return this.lgfId;
    }

    public static class LgfDefinition
    extends TeaModel {
        @NameInMap(value="IntentId")
        @Validation(required=true)
        private Long intentId;
        @NameInMap(value="RuleText")
        @Validation(required=true)
        private String ruleText;

        private LgfDefinition(Builder builder) {
            this.intentId = builder.intentId;
            this.ruleText = builder.ruleText;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static LgfDefinition create() {
            return LgfDefinition.builder().build();
        }

        public Long getIntentId() {
            return this.intentId;
        }

        public String getRuleText() {
            return this.ruleText;
        }

        public static final class Builder {
            private Long intentId;
            private String ruleText;

            public Builder intentId(Long intentId) {
                this.intentId = intentId;
                return this;
            }

            public Builder ruleText(String ruleText) {
                this.ruleText = ruleText;
                return this;
            }

            public LgfDefinition build() {
                return new LgfDefinition(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<UpdateLgfRequest, Builder> {
        private String regionId;
        private String agentKey;
        private String instanceId;
        private LgfDefinition lgfDefinition;
        private Long lgfId;

        private Builder() {
        }

        private Builder(UpdateLgfRequest request) {
            super((Request)request);
            this.regionId = request.regionId;
            this.agentKey = request.agentKey;
            this.instanceId = request.instanceId;
            this.lgfDefinition = request.lgfDefinition;
            this.lgfId = request.lgfId;
        }

        public Builder regionId(String regionId) {
            this.putHostParameter("RegionId", regionId);
            this.regionId = regionId;
            return this;
        }

        public Builder agentKey(String agentKey) {
            this.putQueryParameter("AgentKey", agentKey);
            this.agentKey = agentKey;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.putQueryParameter("InstanceId", instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public Builder lgfDefinition(LgfDefinition lgfDefinition) {
            String lgfDefinitionShrink = this.shrink((Object)lgfDefinition, "LgfDefinition", "json");
            this.putQueryParameter("LgfDefinition", lgfDefinitionShrink);
            this.lgfDefinition = lgfDefinition;
            return this;
        }

        public Builder lgfId(Long lgfId) {
            this.putQueryParameter("LgfId", lgfId);
            this.lgfId = lgfId;
            return this;
        }

        public UpdateLgfRequest build() {
            return new UpdateLgfRequest(this);
        }
    }
}

