/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ims20190815.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateApplicationRequest
extends Request {
    @Query
    @NameInMap(value="AccessTokenValidity")
    private Integer accessTokenValidity;
    @Query
    @NameInMap(value="AppName")
    private String appName;
    @Query
    @NameInMap(value="AppType")
    @Validation(required=true)
    private String appType;
    @Query
    @NameInMap(value="DisplayName")
    @Validation(required=true)
    private String displayName;
    @Query
    @NameInMap(value="IsMultiTenant")
    private Boolean isMultiTenant;
    @Query
    @NameInMap(value="PredefinedScopes")
    private String predefinedScopes;
    @Query
    @NameInMap(value="RedirectUris")
    private String redirectUris;
    @Query
    @NameInMap(value="RefreshTokenValidity")
    private Integer refreshTokenValidity;
    @Query
    @NameInMap(value="RequiredScopes")
    private String requiredScopes;
    @Query
    @NameInMap(value="SecretRequired")
    private Boolean secretRequired;

    private CreateApplicationRequest(Builder builder) {
        super((Request.Builder)builder);
        this.accessTokenValidity = builder.accessTokenValidity;
        this.appName = builder.appName;
        this.appType = builder.appType;
        this.displayName = builder.displayName;
        this.isMultiTenant = builder.isMultiTenant;
        this.predefinedScopes = builder.predefinedScopes;
        this.redirectUris = builder.redirectUris;
        this.refreshTokenValidity = builder.refreshTokenValidity;
        this.requiredScopes = builder.requiredScopes;
        this.secretRequired = builder.secretRequired;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateApplicationRequest create() {
        return CreateApplicationRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Integer getAccessTokenValidity() {
        return this.accessTokenValidity;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppType() {
        return this.appType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Boolean getIsMultiTenant() {
        return this.isMultiTenant;
    }

    public String getPredefinedScopes() {
        return this.predefinedScopes;
    }

    public String getRedirectUris() {
        return this.redirectUris;
    }

    public Integer getRefreshTokenValidity() {
        return this.refreshTokenValidity;
    }

    public String getRequiredScopes() {
        return this.requiredScopes;
    }

    public Boolean getSecretRequired() {
        return this.secretRequired;
    }

    public static final class Builder
    extends Request.Builder<CreateApplicationRequest, Builder> {
        private Integer accessTokenValidity;
        private String appName;
        private String appType;
        private String displayName;
        private Boolean isMultiTenant;
        private String predefinedScopes;
        private String redirectUris;
        private Integer refreshTokenValidity;
        private String requiredScopes;
        private Boolean secretRequired;

        private Builder() {
        }

        private Builder(CreateApplicationRequest request) {
            super((Request)request);
            this.accessTokenValidity = request.accessTokenValidity;
            this.appName = request.appName;
            this.appType = request.appType;
            this.displayName = request.displayName;
            this.isMultiTenant = request.isMultiTenant;
            this.predefinedScopes = request.predefinedScopes;
            this.redirectUris = request.redirectUris;
            this.refreshTokenValidity = request.refreshTokenValidity;
            this.requiredScopes = request.requiredScopes;
            this.secretRequired = request.secretRequired;
        }

        public Builder accessTokenValidity(Integer accessTokenValidity) {
            this.putQueryParameter("AccessTokenValidity", accessTokenValidity);
            this.accessTokenValidity = accessTokenValidity;
            return this;
        }

        public Builder appName(String appName) {
            this.putQueryParameter("AppName", appName);
            this.appName = appName;
            return this;
        }

        public Builder appType(String appType) {
            this.putQueryParameter("AppType", appType);
            this.appType = appType;
            return this;
        }

        public Builder displayName(String displayName) {
            this.putQueryParameter("DisplayName", displayName);
            this.displayName = displayName;
            return this;
        }

        public Builder isMultiTenant(Boolean isMultiTenant) {
            this.putQueryParameter("IsMultiTenant", isMultiTenant);
            this.isMultiTenant = isMultiTenant;
            return this;
        }

        public Builder predefinedScopes(String predefinedScopes) {
            this.putQueryParameter("PredefinedScopes", predefinedScopes);
            this.predefinedScopes = predefinedScopes;
            return this;
        }

        public Builder redirectUris(String redirectUris) {
            this.putQueryParameter("RedirectUris", redirectUris);
            this.redirectUris = redirectUris;
            return this;
        }

        public Builder refreshTokenValidity(Integer refreshTokenValidity) {
            this.putQueryParameter("RefreshTokenValidity", refreshTokenValidity);
            this.refreshTokenValidity = refreshTokenValidity;
            return this;
        }

        public Builder requiredScopes(String requiredScopes) {
            this.putQueryParameter("RequiredScopes", requiredScopes);
            this.requiredScopes = requiredScopes;
            return this;
        }

        public Builder secretRequired(Boolean secretRequired) {
            this.putQueryParameter("SecretRequired", secretRequired);
            this.secretRequired = secretRequired;
            return this;
        }

        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }
    }
}

