/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ims20190815.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;

public class CreateOIDCProviderRequest
extends Request {
    @Query
    @NameInMap(value="ClientIds")
    private String clientIds;
    @Query
    @NameInMap(value="Description")
    private String description;
    @Query
    @NameInMap(value="Fingerprints")
    private String fingerprints;
    @Query
    @NameInMap(value="IssuanceLimitTime")
    private Long issuanceLimitTime;
    @Query
    @NameInMap(value="IssuerUrl")
    private String issuerUrl;
    @Query
    @NameInMap(value="OIDCProviderName")
    private String OIDCProviderName;

    private CreateOIDCProviderRequest(Builder builder) {
        super((Request.Builder)builder);
        this.clientIds = builder.clientIds;
        this.description = builder.description;
        this.fingerprints = builder.fingerprints;
        this.issuanceLimitTime = builder.issuanceLimitTime;
        this.issuerUrl = builder.issuerUrl;
        this.OIDCProviderName = builder.OIDCProviderName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateOIDCProviderRequest create() {
        return CreateOIDCProviderRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getClientIds() {
        return this.clientIds;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFingerprints() {
        return this.fingerprints;
    }

    public Long getIssuanceLimitTime() {
        return this.issuanceLimitTime;
    }

    public String getIssuerUrl() {
        return this.issuerUrl;
    }

    public String getOIDCProviderName() {
        return this.OIDCProviderName;
    }

    public static final class Builder
    extends Request.Builder<CreateOIDCProviderRequest, Builder> {
        private String clientIds;
        private String description;
        private String fingerprints;
        private Long issuanceLimitTime;
        private String issuerUrl;
        private String OIDCProviderName;

        private Builder() {
        }

        private Builder(CreateOIDCProviderRequest request) {
            super((Request)request);
            this.clientIds = request.clientIds;
            this.description = request.description;
            this.fingerprints = request.fingerprints;
            this.issuanceLimitTime = request.issuanceLimitTime;
            this.issuerUrl = request.issuerUrl;
            this.OIDCProviderName = request.OIDCProviderName;
        }

        public Builder clientIds(String clientIds) {
            this.putQueryParameter("ClientIds", clientIds);
            this.clientIds = clientIds;
            return this;
        }

        public Builder description(String description) {
            this.putQueryParameter("Description", description);
            this.description = description;
            return this;
        }

        public Builder fingerprints(String fingerprints) {
            this.putQueryParameter("Fingerprints", fingerprints);
            this.fingerprints = fingerprints;
            return this;
        }

        public Builder issuanceLimitTime(Long issuanceLimitTime) {
            this.putQueryParameter("IssuanceLimitTime", issuanceLimitTime);
            this.issuanceLimitTime = issuanceLimitTime;
            return this;
        }

        public Builder issuerUrl(String issuerUrl) {
            this.putQueryParameter("IssuerUrl", issuerUrl);
            this.issuerUrl = issuerUrl;
            return this;
        }

        public Builder OIDCProviderName(String OIDCProviderName) {
            this.putQueryParameter("OIDCProviderName", OIDCProviderName);
            this.OIDCProviderName = OIDCProviderName;
            return this;
        }

        public CreateOIDCProviderRequest build() {
            return new CreateOIDCProviderRequest(this);
        }
    }
}

