/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ims20190815.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;
import darabonba.core.TeaModel;
import java.util.List;

public class CreateUserRequest
extends Request {
    @Query
    @NameInMap(value="Comments")
    private String comments;
    @Query
    @NameInMap(value="DisplayName")
    @Validation(required=true)
    private String displayName;
    @Query
    @NameInMap(value="Email")
    private String email;
    @Query
    @NameInMap(value="MobilePhone")
    private String mobilePhone;
    @Query
    @NameInMap(value="Tag")
    private List<Tag> tag;
    @Query
    @NameInMap(value="UserPrincipalName")
    @Validation(required=true)
    private String userPrincipalName;

    private CreateUserRequest(Builder builder) {
        super((Request.Builder)builder);
        this.comments = builder.comments;
        this.displayName = builder.displayName;
        this.email = builder.email;
        this.mobilePhone = builder.mobilePhone;
        this.tag = builder.tag;
        this.userPrincipalName = builder.userPrincipalName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CreateUserRequest create() {
        return CreateUserRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getComments() {
        return this.comments;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public List<Tag> getTag() {
        return this.tag;
    }

    public String getUserPrincipalName() {
        return this.userPrincipalName;
    }

    public static class Tag
    extends TeaModel {
        @NameInMap(value="Key")
        private String key;
        @NameInMap(value="Value")
        private String value;

        private Tag(Builder builder) {
            this.key = builder.key;
            this.value = builder.value;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static Tag create() {
            return Tag.builder().build();
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public static final class Builder {
            private String key;
            private String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public Tag build() {
                return new Tag(this);
            }
        }
    }

    public static final class Builder
    extends Request.Builder<CreateUserRequest, Builder> {
        private String comments;
        private String displayName;
        private String email;
        private String mobilePhone;
        private List<Tag> tag;
        private String userPrincipalName;

        private Builder() {
        }

        private Builder(CreateUserRequest request) {
            super((Request)request);
            this.comments = request.comments;
            this.displayName = request.displayName;
            this.email = request.email;
            this.mobilePhone = request.mobilePhone;
            this.tag = request.tag;
            this.userPrincipalName = request.userPrincipalName;
        }

        public Builder comments(String comments) {
            this.putQueryParameter("Comments", comments);
            this.comments = comments;
            return this;
        }

        public Builder displayName(String displayName) {
            this.putQueryParameter("DisplayName", displayName);
            this.displayName = displayName;
            return this;
        }

        public Builder email(String email) {
            this.putQueryParameter("Email", email);
            this.email = email;
            return this;
        }

        public Builder mobilePhone(String mobilePhone) {
            this.putQueryParameter("MobilePhone", mobilePhone);
            this.mobilePhone = mobilePhone;
            return this;
        }

        public Builder tag(List<Tag> tag) {
            this.putQueryParameter("Tag", tag);
            this.tag = tag;
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.putQueryParameter("UserPrincipalName", userPrincipalName);
            this.userPrincipalName = userPrincipalName;
            return this;
        }

        public CreateUserRequest build() {
            return new CreateUserRequest(this);
        }
    }
}

