/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ims20190815.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class GetAppSecretRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="AppSecretId")
    @Validation(required=true)
    private String appSecretId;

    private GetAppSecretRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.appSecretId = builder.appSecretId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static GetAppSecretRequest create() {
        return GetAppSecretRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppSecretId() {
        return this.appSecretId;
    }

    public static final class Builder
    extends Request.Builder<GetAppSecretRequest, Builder> {
        private String appId;
        private String appSecretId;

        private Builder() {
        }

        private Builder(GetAppSecretRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.appSecretId = request.appSecretId;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder appSecretId(String appSecretId) {
            this.putQueryParameter("AppSecretId", appSecretId);
            this.appSecretId = appSecretId;
            return this;
        }

        public GetAppSecretRequest build() {
            return new GetAppSecretRequest(this);
        }
    }
}

