/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ims20190815.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.pop.models.Request;

public class ProvisionApplicationRequest
extends Request {
    @Query
    @NameInMap(value="AppId")
    @Validation(required=true)
    private String appId;
    @Query
    @NameInMap(value="Scopes")
    private String scopes;

    private ProvisionApplicationRequest(Builder builder) {
        super((Request.Builder)builder);
        this.appId = builder.appId;
        this.scopes = builder.scopes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ProvisionApplicationRequest create() {
        return ProvisionApplicationRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getScopes() {
        return this.scopes;
    }

    public static final class Builder
    extends Request.Builder<ProvisionApplicationRequest, Builder> {
        private String appId;
        private String scopes;

        private Builder() {
        }

        private Builder(ProvisionApplicationRequest request) {
            super((Request)request);
            this.appId = request.appId;
            this.scopes = request.scopes;
        }

        public Builder appId(String appId) {
            this.putQueryParameter("AppId", appId);
            this.appId = appId;
            return this;
        }

        public Builder scopes(String scopes) {
            this.putQueryParameter("Scopes", scopes);
            this.scopes = scopes;
            return this;
        }

        public ProvisionApplicationRequest build() {
            return new ProvisionApplicationRequest(this);
        }
    }
}

