/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Header;
import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;
import com.aliyun.sdk.service.oss20190517.models.ObjectACL;
import com.aliyun.sdk.service.oss20190517.models.StorageClass;
import java.util.Map;

public class CopyObjectRequest
extends Request {
    @Path
    @NameInMap(value="key")
    @Validation(required=true)
    private String key;
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;
    @Header
    @NameInMap(value="x-oss-copy-source")
    @Validation(required=true)
    private String copySource;
    @Header
    @NameInMap(value="x-oss-copy-source-if-match")
    private String copySourceIfMatch;
    @Header
    @NameInMap(value="x-oss-copy-source-if-modified-since")
    private String copySourceIfModifiedSince;
    @Header
    @NameInMap(value="x-oss-copy-source-if-none-match")
    private String copySourceIfNoneMatch;
    @Header
    @NameInMap(value="x-oss-copy-source-if-unmodified-since")
    private String copySourceIfUnmodifiedSince;
    @Header
    @NameInMap(value="x-oss-forbid-overwrite")
    private String forbidOverwrite;
    @Header
    @NameInMap(value="x-oss-meta-*")
    private Map<String, String> metaData;
    @Header
    @NameInMap(value="x-oss-metadata-directive")
    private String metadataDirective;
    @Header
    @NameInMap(value="x-oss-object-acl")
    private String acl;
    @Header
    @NameInMap(value="x-oss-server-side-encryption")
    private String serverSideEncryption;
    @Header
    @NameInMap(value="x-oss-server-side-encryption-key-id")
    private String sseKeyId;
    @Header
    @NameInMap(value="x-oss-storage-class")
    private String storageClass;
    @Header
    @NameInMap(value="x-oss-tagging")
    private String tagging;
    @Header
    @NameInMap(value="x-oss-tagging-directive")
    private String taggingDirective;

    private CopyObjectRequest(Builder builder) {
        super((Request.Builder)builder);
        this.key = builder.key;
        this.bucket = builder.bucket;
        this.copySource = builder.copySource;
        this.copySourceIfMatch = builder.copySourceIfMatch;
        this.copySourceIfModifiedSince = builder.copySourceIfModifiedSince;
        this.copySourceIfNoneMatch = builder.copySourceIfNoneMatch;
        this.copySourceIfUnmodifiedSince = builder.copySourceIfUnmodifiedSince;
        this.forbidOverwrite = builder.forbidOverwrite;
        this.metaData = builder.metaData;
        this.metadataDirective = builder.metadataDirective;
        this.acl = builder.acl;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.sseKeyId = builder.sseKeyId;
        this.storageClass = builder.storageClass;
        this.tagging = builder.tagging;
        this.taggingDirective = builder.taggingDirective;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CopyObjectRequest create() {
        return CopyObjectRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getCopySource() {
        return this.copySource;
    }

    public String getCopySourceIfMatch() {
        return this.copySourceIfMatch;
    }

    public String getCopySourceIfModifiedSince() {
        return this.copySourceIfModifiedSince;
    }

    public String getCopySourceIfNoneMatch() {
        return this.copySourceIfNoneMatch;
    }

    public String getCopySourceIfUnmodifiedSince() {
        return this.copySourceIfUnmodifiedSince;
    }

    public String getForbidOverwrite() {
        return this.forbidOverwrite;
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public String getMetadataDirective() {
        return this.metadataDirective;
    }

    public String getAcl() {
        return this.acl;
    }

    public String getServerSideEncryption() {
        return this.serverSideEncryption;
    }

    public String getSseKeyId() {
        return this.sseKeyId;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public String getTagging() {
        return this.tagging;
    }

    public String getTaggingDirective() {
        return this.taggingDirective;
    }

    public static final class Builder
    extends Request.Builder<CopyObjectRequest, Builder> {
        private String key;
        private String bucket;
        private String copySource;
        private String copySourceIfMatch;
        private String copySourceIfModifiedSince;
        private String copySourceIfNoneMatch;
        private String copySourceIfUnmodifiedSince;
        private String forbidOverwrite;
        private Map<String, String> metaData;
        private String metadataDirective;
        private String acl;
        private String serverSideEncryption;
        private String sseKeyId;
        private String storageClass;
        private String tagging;
        private String taggingDirective;

        private Builder() {
        }

        private Builder(CopyObjectRequest request) {
            super((Request)request);
            this.key = request.key;
            this.bucket = request.bucket;
            this.copySource = request.copySource;
            this.copySourceIfMatch = request.copySourceIfMatch;
            this.copySourceIfModifiedSince = request.copySourceIfModifiedSince;
            this.copySourceIfNoneMatch = request.copySourceIfNoneMatch;
            this.copySourceIfUnmodifiedSince = request.copySourceIfUnmodifiedSince;
            this.forbidOverwrite = request.forbidOverwrite;
            this.metaData = request.metaData;
            this.metadataDirective = request.metadataDirective;
            this.acl = request.acl;
            this.serverSideEncryption = request.serverSideEncryption;
            this.sseKeyId = request.sseKeyId;
            this.storageClass = request.storageClass;
            this.tagging = request.tagging;
            this.taggingDirective = request.taggingDirective;
        }

        public Builder key(String key) {
            this.putPathParameter("key", key);
            this.key = key;
            return this;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public Builder copySource(String copySource) {
            this.putHeaderParameter("x-oss-copy-source", copySource);
            this.copySource = copySource;
            return this;
        }

        public Builder copySourceIfMatch(String copySourceIfMatch) {
            this.putHeaderParameter("x-oss-copy-source-if-match", copySourceIfMatch);
            this.copySourceIfMatch = copySourceIfMatch;
            return this;
        }

        public Builder copySourceIfModifiedSince(String copySourceIfModifiedSince) {
            this.putHeaderParameter("x-oss-copy-source-if-modified-since", copySourceIfModifiedSince);
            this.copySourceIfModifiedSince = copySourceIfModifiedSince;
            return this;
        }

        public Builder copySourceIfNoneMatch(String copySourceIfNoneMatch) {
            this.putHeaderParameter("x-oss-copy-source-if-none-match", copySourceIfNoneMatch);
            this.copySourceIfNoneMatch = copySourceIfNoneMatch;
            return this;
        }

        public Builder copySourceIfUnmodifiedSince(String copySourceIfUnmodifiedSince) {
            this.putHeaderParameter("x-oss-copy-source-if-unmodified-since", copySourceIfUnmodifiedSince);
            this.copySourceIfUnmodifiedSince = copySourceIfUnmodifiedSince;
            return this;
        }

        public Builder forbidOverwrite(String forbidOverwrite) {
            this.putHeaderParameter("x-oss-forbid-overwrite", forbidOverwrite);
            this.forbidOverwrite = forbidOverwrite;
            return this;
        }

        public Builder metaData(Map<String, String> metaData) {
            this.putHeaderParameter("x-oss-meta-*", metaData);
            this.metaData = metaData;
            return this;
        }

        public Builder metadataDirective(String metadataDirective) {
            this.putHeaderParameter("x-oss-metadata-directive", metadataDirective);
            this.metadataDirective = metadataDirective;
            return this;
        }

        public Builder acl(String acl) {
            this.putHeaderParameter("x-oss-object-acl", acl);
            this.acl = acl;
            return this;
        }

        public Builder acl(ObjectACL acl) {
            this.putHeaderParameter("x-oss-object-acl", acl.getValue());
            this.acl = acl.getValue();
            return this;
        }

        public Builder serverSideEncryption(String serverSideEncryption) {
            this.putHeaderParameter("x-oss-server-side-encryption", serverSideEncryption);
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        public Builder sseKeyId(String sseKeyId) {
            this.putHeaderParameter("x-oss-server-side-encryption-key-id", sseKeyId);
            this.sseKeyId = sseKeyId;
            return this;
        }

        public Builder storageClass(String storageClass) {
            this.putHeaderParameter("x-oss-storage-class", storageClass);
            this.storageClass = storageClass;
            return this;
        }

        public Builder storageClass(StorageClass storageClass) {
            this.putHeaderParameter("x-oss-storage-class", storageClass.getValue());
            this.storageClass = storageClass.getValue();
            return this;
        }

        public Builder tagging(String tagging) {
            this.putHeaderParameter("x-oss-tagging", tagging);
            this.tagging = tagging;
            return this;
        }

        public Builder taggingDirective(String taggingDirective) {
            this.putHeaderParameter("x-oss-tagging-directive", taggingDirective);
            this.taggingDirective = taggingDirective;
            return this;
        }

        public CopyObjectRequest build() {
            return new CopyObjectRequest(this);
        }
    }
}

