/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Header;
import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;
import com.aliyun.sdk.service.oss20190517.models.EncodeType;
import com.aliyun.sdk.service.oss20190517.models.StorageClass;

public class InitiateMultipartUploadRequest
extends Request {
    @Path
    @NameInMap(value="key")
    @Validation(required=true)
    private String key;
    @Header
    @NameInMap(value="Cache-Control")
    private String cacheControl;
    @Header
    @NameInMap(value="Content-Disposition")
    private String contentDisposition;
    @Header
    @NameInMap(value="Content-Encoding")
    private String contentEncoding;
    @Header
    @NameInMap(value="Expires")
    private String expires;
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;
    @Query
    @NameInMap(value="encoding-type")
    private String encodingType;
    @Header
    @NameInMap(value="x-oss-forbid-overwrite")
    private String forbidOverwrite;
    @Header
    @NameInMap(value="x-oss-server-side-data-encryption")
    private String sseDataEncryption;
    @Header
    @NameInMap(value="x-oss-server-side-encryption")
    private String serverSideEncryption;
    @Header
    @NameInMap(value="x-oss-server-side-encryption-key-id")
    private String sseKeyId;
    @Header
    @NameInMap(value="x-oss-storage-class")
    private String storageClass;
    @Header
    @NameInMap(value="x-oss-tagging")
    private String tagging;

    private InitiateMultipartUploadRequest(Builder builder) {
        super((Request.Builder)builder);
        this.key = builder.key;
        this.cacheControl = builder.cacheControl;
        this.contentDisposition = builder.contentDisposition;
        this.contentEncoding = builder.contentEncoding;
        this.expires = builder.expires;
        this.bucket = builder.bucket;
        this.encodingType = builder.encodingType;
        this.forbidOverwrite = builder.forbidOverwrite;
        this.sseDataEncryption = builder.sseDataEncryption;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.sseKeyId = builder.sseKeyId;
        this.storageClass = builder.storageClass;
        this.tagging = builder.tagging;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static InitiateMultipartUploadRequest create() {
        return InitiateMultipartUploadRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getExpires() {
        return this.expires;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public String getForbidOverwrite() {
        return this.forbidOverwrite;
    }

    public String getSseDataEncryption() {
        return this.sseDataEncryption;
    }

    public String getServerSideEncryption() {
        return this.serverSideEncryption;
    }

    public String getSseKeyId() {
        return this.sseKeyId;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public String getTagging() {
        return this.tagging;
    }

    public static final class Builder
    extends Request.Builder<InitiateMultipartUploadRequest, Builder> {
        private String key;
        private String cacheControl;
        private String contentDisposition;
        private String contentEncoding;
        private String expires;
        private String bucket;
        private String encodingType;
        private String forbidOverwrite;
        private String sseDataEncryption;
        private String serverSideEncryption;
        private String sseKeyId;
        private String storageClass;
        private String tagging;

        private Builder() {
        }

        private Builder(InitiateMultipartUploadRequest request) {
            super((Request)request);
            this.key = request.key;
            this.cacheControl = request.cacheControl;
            this.contentDisposition = request.contentDisposition;
            this.contentEncoding = request.contentEncoding;
            this.expires = request.expires;
            this.bucket = request.bucket;
            this.encodingType = request.encodingType;
            this.forbidOverwrite = request.forbidOverwrite;
            this.sseDataEncryption = request.sseDataEncryption;
            this.serverSideEncryption = request.serverSideEncryption;
            this.sseKeyId = request.sseKeyId;
            this.storageClass = request.storageClass;
            this.tagging = request.tagging;
        }

        public Builder key(String key) {
            this.putPathParameter("key", key);
            this.key = key;
            return this;
        }

        public Builder cacheControl(String cacheControl) {
            this.putHeaderParameter("Cache-Control", cacheControl);
            this.cacheControl = cacheControl;
            return this;
        }

        public Builder contentDisposition(String contentDisposition) {
            this.putHeaderParameter("Content-Disposition", contentDisposition);
            this.contentDisposition = contentDisposition;
            return this;
        }

        public Builder contentEncoding(String contentEncoding) {
            this.putHeaderParameter("Content-Encoding", contentEncoding);
            this.contentEncoding = contentEncoding;
            return this;
        }

        public Builder expires(String expires) {
            this.putHeaderParameter("Expires", expires);
            this.expires = expires;
            return this;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public Builder encodingType(String encodingType) {
            this.putQueryParameter("encoding-type", encodingType);
            this.encodingType = encodingType;
            return this;
        }

        public Builder encodingType(EncodeType encodingType) {
            this.putQueryParameter("encoding-type", encodingType.getValue());
            this.encodingType = encodingType.getValue();
            return this;
        }

        public Builder forbidOverwrite(String forbidOverwrite) {
            this.putHeaderParameter("x-oss-forbid-overwrite", forbidOverwrite);
            this.forbidOverwrite = forbidOverwrite;
            return this;
        }

        public Builder sseDataEncryption(String sseDataEncryption) {
            this.putHeaderParameter("x-oss-server-side-data-encryption", sseDataEncryption);
            this.sseDataEncryption = sseDataEncryption;
            return this;
        }

        public Builder serverSideEncryption(String serverSideEncryption) {
            this.putHeaderParameter("x-oss-server-side-encryption", serverSideEncryption);
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        public Builder sseKeyId(String sseKeyId) {
            this.putHeaderParameter("x-oss-server-side-encryption-key-id", sseKeyId);
            this.sseKeyId = sseKeyId;
            return this;
        }

        public Builder storageClass(String storageClass) {
            this.putHeaderParameter("x-oss-storage-class", storageClass);
            this.storageClass = storageClass;
            return this;
        }

        public Builder storageClass(StorageClass storageClass) {
            this.putHeaderParameter("x-oss-storage-class", storageClass.getValue());
            this.storageClass = storageClass.getValue();
            return this;
        }

        public Builder tagging(String tagging) {
            this.putHeaderParameter("x-oss-tagging", tagging);
            this.tagging = tagging;
            return this;
        }

        public InitiateMultipartUploadRequest build() {
            return new InitiateMultipartUploadRequest(this);
        }
    }
}

