/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;

public class ListBucketInventoryRequest
extends Request {
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;
    @Query
    @NameInMap(value="continuation-token")
    private String continuationToken;

    private ListBucketInventoryRequest(Builder builder) {
        super((Request.Builder)builder);
        this.bucket = builder.bucket;
        this.continuationToken = builder.continuationToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ListBucketInventoryRequest create() {
        return ListBucketInventoryRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getContinuationToken() {
        return this.continuationToken;
    }

    public static final class Builder
    extends Request.Builder<ListBucketInventoryRequest, Builder> {
        private String bucket;
        private String continuationToken;

        private Builder() {
        }

        private Builder(ListBucketInventoryRequest request) {
            super((Request)request);
            this.bucket = request.bucket;
            this.continuationToken = request.continuationToken;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public Builder continuationToken(String continuationToken) {
            this.putQueryParameter("continuation-token", continuationToken);
            this.continuationToken = continuationToken;
            return this;
        }

        public ListBucketInventoryRequest build() {
            return new ListBucketInventoryRequest(this);
        }
    }
}

