/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Body;
import com.aliyun.core.annotation.Header;
import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;
import com.aliyun.sdk.service.oss20190517.models.BucketACL;
import com.aliyun.sdk.service.oss20190517.models.CreateBucketConfiguration;

public class PutBucketRequest
extends Request {
    @Body
    @NameInMap(value="CreateBucketConfiguration")
    private CreateBucketConfiguration createBucketConfiguration;
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;
    @Header
    @NameInMap(value="x-oss-acl")
    private String acl;

    private PutBucketRequest(Builder builder) {
        super((Request.Builder)builder);
        this.createBucketConfiguration = builder.createBucketConfiguration;
        this.bucket = builder.bucket;
        this.acl = builder.acl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PutBucketRequest create() {
        return PutBucketRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public CreateBucketConfiguration getCreateBucketConfiguration() {
        return this.createBucketConfiguration;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getAcl() {
        return this.acl;
    }

    public static final class Builder
    extends Request.Builder<PutBucketRequest, Builder> {
        private CreateBucketConfiguration createBucketConfiguration;
        private String bucket;
        private String acl;

        private Builder() {
        }

        private Builder(PutBucketRequest request) {
            super((Request)request);
            this.createBucketConfiguration = request.createBucketConfiguration;
            this.bucket = request.bucket;
            this.acl = request.acl;
        }

        public Builder createBucketConfiguration(CreateBucketConfiguration createBucketConfiguration) {
            this.putBodyParameter("CreateBucketConfiguration", (Object)createBucketConfiguration);
            this.createBucketConfiguration = createBucketConfiguration;
            return this;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public Builder acl(String acl) {
            this.putHeaderParameter("x-oss-acl", acl);
            this.acl = acl;
            return this;
        }

        public Builder acl(BucketACL acl) {
            this.putHeaderParameter("x-oss-acl", acl.getValue());
            this.acl = acl.getValue();
            return this;
        }

        public PutBucketRequest build() {
            return new PutBucketRequest(this);
        }
    }
}

