/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Header;
import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;
import com.aliyun.sdk.service.oss20190517.models.ObjectACL;
import com.aliyun.sdk.service.oss20190517.models.StorageClass;

public class PutSymlinkRequest
extends Request {
    @Path
    @NameInMap(value="key")
    @Validation(required=true)
    private String key;
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;
    @Header
    @NameInMap(value="x-oss-forbid-overwrite")
    private String forbidOverwrite;
    @Header
    @NameInMap(value="x-oss-object-acl")
    private String acl;
    @Header
    @NameInMap(value="x-oss-storage-class")
    private String storageClass;
    @Header
    @NameInMap(value="x-oss-symlink-target")
    @Validation(required=true)
    private String symlinkTargetKey;

    private PutSymlinkRequest(Builder builder) {
        super((Request.Builder)builder);
        this.key = builder.key;
        this.bucket = builder.bucket;
        this.forbidOverwrite = builder.forbidOverwrite;
        this.acl = builder.acl;
        this.storageClass = builder.storageClass;
        this.symlinkTargetKey = builder.symlinkTargetKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PutSymlinkRequest create() {
        return PutSymlinkRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getForbidOverwrite() {
        return this.forbidOverwrite;
    }

    public String getAcl() {
        return this.acl;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public String getSymlinkTargetKey() {
        return this.symlinkTargetKey;
    }

    public static final class Builder
    extends Request.Builder<PutSymlinkRequest, Builder> {
        private String key;
        private String bucket;
        private String forbidOverwrite;
        private String acl;
        private String storageClass;
        private String symlinkTargetKey;

        private Builder() {
        }

        private Builder(PutSymlinkRequest request) {
            super((Request)request);
            this.key = request.key;
            this.bucket = request.bucket;
            this.forbidOverwrite = request.forbidOverwrite;
            this.acl = request.acl;
            this.storageClass = request.storageClass;
            this.symlinkTargetKey = request.symlinkTargetKey;
        }

        public Builder key(String key) {
            this.putPathParameter("key", key);
            this.key = key;
            return this;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public Builder forbidOverwrite(String forbidOverwrite) {
            this.putHeaderParameter("x-oss-forbid-overwrite", forbidOverwrite);
            this.forbidOverwrite = forbidOverwrite;
            return this;
        }

        public Builder acl(String acl) {
            this.putHeaderParameter("x-oss-object-acl", acl);
            this.acl = acl;
            return this;
        }

        public Builder acl(ObjectACL acl) {
            this.putHeaderParameter("x-oss-object-acl", acl.getValue());
            this.acl = acl.getValue();
            return this;
        }

        public Builder storageClass(String storageClass) {
            this.putHeaderParameter("x-oss-storage-class", storageClass);
            this.storageClass = storageClass;
            return this;
        }

        public Builder storageClass(StorageClass storageClass) {
            this.putHeaderParameter("x-oss-storage-class", storageClass.getValue());
            this.storageClass = storageClass.getValue();
            return this;
        }

        public Builder symlinkTargetKey(String symlinkTargetKey) {
            this.putHeaderParameter("x-oss-symlink-target", symlinkTargetKey);
            this.symlinkTargetKey = symlinkTargetKey;
            return this;
        }

        public PutSymlinkRequest build() {
            return new PutSymlinkRequest(this);
        }
    }
}

