/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.oss20190517.models;

import com.aliyun.core.annotation.Header;
import com.aliyun.core.annotation.Host;
import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Path;
import com.aliyun.core.annotation.Query;
import com.aliyun.core.annotation.Validation;
import com.aliyun.sdk.gateway.oss.models.Request;

public class UploadPartCopyRequest
extends Request {
    @Path
    @NameInMap(value="key")
    @Validation(required=true)
    private String key;
    @Host
    @NameInMap(value="bucket")
    @Validation(required=true)
    private String bucket;
    @Query
    @NameInMap(value="partNumber")
    @Validation(required=true)
    private Long partNumber;
    @Query
    @NameInMap(value="uploadId")
    @Validation(required=true)
    private String uploadId;
    @Header
    @NameInMap(value="x-oss-copy-source")
    @Validation(required=true)
    private String copySource;
    @Header
    @NameInMap(value="x-oss-copy-source-if-match")
    private String copySourceIfMatch;
    @Header
    @NameInMap(value="x-oss-copy-source-if-modified-since")
    private String copySourceIfModifiedSince;
    @Header
    @NameInMap(value="x-oss-copy-source-if-none-match")
    private String copySourceIfNoneMatch;
    @Header
    @NameInMap(value="x-oss-copy-source-if-unmodified-since")
    private String copySourceIfUnmodifiedSince;
    @Header
    @NameInMap(value="x-oss-copy-source-range")
    private String copySourceRange;

    private UploadPartCopyRequest(Builder builder) {
        super((Request.Builder)builder);
        this.key = builder.key;
        this.bucket = builder.bucket;
        this.partNumber = builder.partNumber;
        this.uploadId = builder.uploadId;
        this.copySource = builder.copySource;
        this.copySourceIfMatch = builder.copySourceIfMatch;
        this.copySourceIfModifiedSince = builder.copySourceIfModifiedSince;
        this.copySourceIfNoneMatch = builder.copySourceIfNoneMatch;
        this.copySourceIfUnmodifiedSince = builder.copySourceIfUnmodifiedSince;
        this.copySourceRange = builder.copySourceRange;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static UploadPartCopyRequest create() {
        return UploadPartCopyRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getBucket() {
        return this.bucket;
    }

    public Long getPartNumber() {
        return this.partNumber;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public String getCopySource() {
        return this.copySource;
    }

    public String getCopySourceIfMatch() {
        return this.copySourceIfMatch;
    }

    public String getCopySourceIfModifiedSince() {
        return this.copySourceIfModifiedSince;
    }

    public String getCopySourceIfNoneMatch() {
        return this.copySourceIfNoneMatch;
    }

    public String getCopySourceIfUnmodifiedSince() {
        return this.copySourceIfUnmodifiedSince;
    }

    public String getCopySourceRange() {
        return this.copySourceRange;
    }

    public static final class Builder
    extends Request.Builder<UploadPartCopyRequest, Builder> {
        private String key;
        private String bucket;
        private Long partNumber;
        private String uploadId;
        private String copySource;
        private String copySourceIfMatch;
        private String copySourceIfModifiedSince;
        private String copySourceIfNoneMatch;
        private String copySourceIfUnmodifiedSince;
        private String copySourceRange;

        private Builder() {
        }

        private Builder(UploadPartCopyRequest request) {
            super((Request)request);
            this.key = request.key;
            this.bucket = request.bucket;
            this.partNumber = request.partNumber;
            this.uploadId = request.uploadId;
            this.copySource = request.copySource;
            this.copySourceIfMatch = request.copySourceIfMatch;
            this.copySourceIfModifiedSince = request.copySourceIfModifiedSince;
            this.copySourceIfNoneMatch = request.copySourceIfNoneMatch;
            this.copySourceIfUnmodifiedSince = request.copySourceIfUnmodifiedSince;
            this.copySourceRange = request.copySourceRange;
        }

        public Builder key(String key) {
            this.putPathParameter("key", key);
            this.key = key;
            return this;
        }

        public Builder bucket(String bucket) {
            this.putHostParameter("bucket", bucket);
            this.bucket = bucket;
            return this;
        }

        public Builder partNumber(Long partNumber) {
            this.putQueryParameter("partNumber", partNumber);
            this.partNumber = partNumber;
            return this;
        }

        public Builder uploadId(String uploadId) {
            this.putQueryParameter("uploadId", uploadId);
            this.uploadId = uploadId;
            return this;
        }

        public Builder copySource(String copySource) {
            this.putHeaderParameter("x-oss-copy-source", copySource);
            this.copySource = copySource;
            return this;
        }

        public Builder copySourceIfMatch(String copySourceIfMatch) {
            this.putHeaderParameter("x-oss-copy-source-if-match", copySourceIfMatch);
            this.copySourceIfMatch = copySourceIfMatch;
            return this;
        }

        public Builder copySourceIfModifiedSince(String copySourceIfModifiedSince) {
            this.putHeaderParameter("x-oss-copy-source-if-modified-since", copySourceIfModifiedSince);
            this.copySourceIfModifiedSince = copySourceIfModifiedSince;
            return this;
        }

        public Builder copySourceIfNoneMatch(String copySourceIfNoneMatch) {
            this.putHeaderParameter("x-oss-copy-source-if-none-match", copySourceIfNoneMatch);
            this.copySourceIfNoneMatch = copySourceIfNoneMatch;
            return this;
        }

        public Builder copySourceIfUnmodifiedSince(String copySourceIfUnmodifiedSince) {
            this.putHeaderParameter("x-oss-copy-source-if-unmodified-since", copySourceIfUnmodifiedSince);
            this.copySourceIfUnmodifiedSince = copySourceIfUnmodifiedSince;
            return this;
        }

        public Builder copySourceRange(String copySourceRange) {
            this.putHeaderParameter("x-oss-copy-source-range", copySourceRange);
            this.copySourceRange = copySourceRange;
            return this;
        }

        public UploadPartCopyRequest build() {
            return new UploadPartCopyRequest(this);
        }
    }
}

