/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.service.ram20150501.models;

import com.aliyun.core.annotation.NameInMap;
import com.aliyun.core.annotation.Query;
import com.aliyun.sdk.gateway.pop.models.Request;

public class SetPasswordPolicyRequest
extends Request {
    @Query
    @NameInMap(value="HardExpiry")
    private Boolean hardExpiry;
    @Query
    @NameInMap(value="MaxLoginAttemps")
    private Integer maxLoginAttemps;
    @Query
    @NameInMap(value="MaxPasswordAge")
    private Integer maxPasswordAge;
    @Query
    @NameInMap(value="MinimumPasswordLength")
    private Integer minimumPasswordLength;
    @Query
    @NameInMap(value="PasswordReusePrevention")
    private Integer passwordReusePrevention;
    @Query
    @NameInMap(value="RequireLowercaseCharacters")
    private Boolean requireLowercaseCharacters;
    @Query
    @NameInMap(value="RequireNumbers")
    private Boolean requireNumbers;
    @Query
    @NameInMap(value="RequireSymbols")
    private Boolean requireSymbols;
    @Query
    @NameInMap(value="RequireUppercaseCharacters")
    private Boolean requireUppercaseCharacters;

    private SetPasswordPolicyRequest(Builder builder) {
        super((Request.Builder)builder);
        this.hardExpiry = builder.hardExpiry;
        this.maxLoginAttemps = builder.maxLoginAttemps;
        this.maxPasswordAge = builder.maxPasswordAge;
        this.minimumPasswordLength = builder.minimumPasswordLength;
        this.passwordReusePrevention = builder.passwordReusePrevention;
        this.requireLowercaseCharacters = builder.requireLowercaseCharacters;
        this.requireNumbers = builder.requireNumbers;
        this.requireSymbols = builder.requireSymbols;
        this.requireUppercaseCharacters = builder.requireUppercaseCharacters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SetPasswordPolicyRequest create() {
        return SetPasswordPolicyRequest.builder().build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public Boolean getHardExpiry() {
        return this.hardExpiry;
    }

    public Integer getMaxLoginAttemps() {
        return this.maxLoginAttemps;
    }

    public Integer getMaxPasswordAge() {
        return this.maxPasswordAge;
    }

    public Integer getMinimumPasswordLength() {
        return this.minimumPasswordLength;
    }

    public Integer getPasswordReusePrevention() {
        return this.passwordReusePrevention;
    }

    public Boolean getRequireLowercaseCharacters() {
        return this.requireLowercaseCharacters;
    }

    public Boolean getRequireNumbers() {
        return this.requireNumbers;
    }

    public Boolean getRequireSymbols() {
        return this.requireSymbols;
    }

    public Boolean getRequireUppercaseCharacters() {
        return this.requireUppercaseCharacters;
    }

    public static final class Builder
    extends Request.Builder<SetPasswordPolicyRequest, Builder> {
        private Boolean hardExpiry;
        private Integer maxLoginAttemps;
        private Integer maxPasswordAge;
        private Integer minimumPasswordLength;
        private Integer passwordReusePrevention;
        private Boolean requireLowercaseCharacters;
        private Boolean requireNumbers;
        private Boolean requireSymbols;
        private Boolean requireUppercaseCharacters;

        private Builder() {
        }

        private Builder(SetPasswordPolicyRequest request) {
            super((Request)request);
            this.hardExpiry = request.hardExpiry;
            this.maxLoginAttemps = request.maxLoginAttemps;
            this.maxPasswordAge = request.maxPasswordAge;
            this.minimumPasswordLength = request.minimumPasswordLength;
            this.passwordReusePrevention = request.passwordReusePrevention;
            this.requireLowercaseCharacters = request.requireLowercaseCharacters;
            this.requireNumbers = request.requireNumbers;
            this.requireSymbols = request.requireSymbols;
            this.requireUppercaseCharacters = request.requireUppercaseCharacters;
        }

        public Builder hardExpiry(Boolean hardExpiry) {
            this.putQueryParameter("HardExpiry", hardExpiry);
            this.hardExpiry = hardExpiry;
            return this;
        }

        public Builder maxLoginAttemps(Integer maxLoginAttemps) {
            this.putQueryParameter("MaxLoginAttemps", maxLoginAttemps);
            this.maxLoginAttemps = maxLoginAttemps;
            return this;
        }

        public Builder maxPasswordAge(Integer maxPasswordAge) {
            this.putQueryParameter("MaxPasswordAge", maxPasswordAge);
            this.maxPasswordAge = maxPasswordAge;
            return this;
        }

        public Builder minimumPasswordLength(Integer minimumPasswordLength) {
            this.putQueryParameter("MinimumPasswordLength", minimumPasswordLength);
            this.minimumPasswordLength = minimumPasswordLength;
            return this;
        }

        public Builder passwordReusePrevention(Integer passwordReusePrevention) {
            this.putQueryParameter("PasswordReusePrevention", passwordReusePrevention);
            this.passwordReusePrevention = passwordReusePrevention;
            return this;
        }

        public Builder requireLowercaseCharacters(Boolean requireLowercaseCharacters) {
            this.putQueryParameter("RequireLowercaseCharacters", requireLowercaseCharacters);
            this.requireLowercaseCharacters = requireLowercaseCharacters;
            return this;
        }

        public Builder requireNumbers(Boolean requireNumbers) {
            this.putQueryParameter("RequireNumbers", requireNumbers);
            this.requireNumbers = requireNumbers;
            return this;
        }

        public Builder requireSymbols(Boolean requireSymbols) {
            this.putQueryParameter("RequireSymbols", requireSymbols);
            this.requireSymbols = requireSymbols;
            return this;
        }

        public Builder requireUppercaseCharacters(Boolean requireUppercaseCharacters) {
            this.putQueryParameter("RequireUppercaseCharacters", requireUppercaseCharacters);
            this.requireUppercaseCharacters = requireUppercaseCharacters;
            return this;
        }

        public SetPasswordPolicyRequest build() {
            return new SetPasswordPolicyRequest(this);
        }
    }
}

