package com.aliyun.sdk.gateway.oss;

import com.aliyun.sdk.gateway.oss.internal.interceptor.GenerateUrlInterceptor;
import com.aliyun.sdk.gateway.oss.internal.interceptor.MakeMutableHttpRequestInterceptor;
import com.aliyun.sdk.gateway.oss.internal.interceptor.PreSigningInterceptor;
import com.aliyun.sdk.gateway.oss.internal.interceptor.ProcPathRegexInterceptor;
import darabonba.core.client.ClientConfiguration;
import darabonba.core.client.ClientOption;
import darabonba.core.client.IClientBuilder;
import darabonba.core.interceptor.InterceptorChain;

public abstract class BasePresignerClientBuilder<BuilderT extends IClientBuilder<BuilderT, ClientT>, ClientT>  extends BaseClientBuilder<BuilderT, ClientT> {

    @Override
    protected ClientConfiguration finalizeServiceConfiguration(ClientConfiguration configuration) {
        ClientConfiguration config = super.finalizeServiceConfiguration(configuration);

        //interceptor
        InterceptorChain chain = InterceptorChain.create();
        chain.addRequestInterceptor(new ProcPathRegexInterceptor());
        chain.addRequestInterceptor(new PreSigningInterceptor());
        chain.addHttpRequestInterceptor(new MakeMutableHttpRequestInterceptor());
        chain.addHttpRequestInterceptor(new GenerateUrlInterceptor());
        config.setOption(ClientOption.INTERCEPTOR_CHAIN, chain);

        return config;
    }
}