package com.aliyun.sdk.gateway.oss.auth.signer;

import com.aliyun.auth.signature.SignerParams;

import java.time.Instant;
import java.util.List;

public class OSSSignerParams extends SignerParams {
    private List<String> subResources;
    private Instant signatureExpiration;

    protected OSSSignerParams() {
        super();
    }

    public static OSSSignerParams create() {
        return new OSSSignerParams();
    }

    public OSSSignerParams setSubResources(List<String> subResources) {
        this.subResources = subResources;
        return this;
    }

    public List<String> subResources() {
        return this.subResources;
    }

    public OSSSignerParams setSignatureExpiration(Instant signatureExpiration) {
        this.signatureExpiration = signatureExpiration;
        return this;
    }

    public Instant SignatureExpiration() {
        return this.signatureExpiration;
    }
}
