package com.aliyun.sdk.gateway.oss.exception;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class OSSErrorDetails {
    private Map<String, String> errorMap;
    private String rawResponse;

    public String errorMessage() {
        return getErrorField("Message");
    }

    public String errorCode() {
        return getErrorField("Code");
    }

    public String hostId() {
        return getErrorField("HostId");
    }

    public String requestId() {
        return getErrorField("RequestId");
    }

    public String getErrorField(String key) {
        return errorMap.getOrDefault(key, "");
    }

    public String rawResponse() {
        return rawResponse;
    }

    public OSSErrorDetails() {
        this(new HashMap<>(), "");
    }

    public OSSErrorDetails(Map<String, String> errorMap, String rawResponse) {
        this.errorMap = Optional.ofNullable(errorMap).orElse(new HashMap<>());
        this.rawResponse = rawResponse;
    }
}
