package com.aliyun.sdk.gateway.oss.exception;

import darabonba.core.exception.ServerException;
/*
public class OSSServerException extends ServerException {
    private String requestId;
    private int statusCode;

    private Error error;
    private Map<String, String> values;

    private void init(Map<String, String> map) {
        error = Error.builder()
                .code(map.getOrDefault("Code", ""))
                .message(map.getOrDefault("Message", ""))
                .hostId(map.getOrDefault("HostId", ""))
                .requestId(map.getOrDefault("RequestId", ""))
                .build();
        values = map;
    }

    public OSSServerException() {
        super();
        init(new HashMap<>());
    }

    public OSSServerException(Map<String, String> map) {
        super();
        init(Optional.ofNullable(map).orElse(new HashMap<>()));
    }

    public OSSServerException(String code, String message,  String requestId, String hostId, Throwable cause) {
        super(null, cause);
        error = Error.builder()
                .code(code)
                .message(message)
                .hostId(requestId)
                .requestId(hostId)
                .build();
        values = new HashMap<>();
    }

    public OSSServerException(String message, Throwable cause) {
        super(message, cause);
        init(new HashMap<>());
    }

    public Error getError() {
        return error;
    }

    public String getErrorValue(String key) {
        return values.getOrDefault(key, "");
    }

    @Override
    public String getMessage() {
        return error.message() + "\n[Code]: " + error.code() + "\n[RequestId]: " + error.requestId()
                + "\n[HostId]: " + error.hostId();
    }
}
 */

public class OSSServerException extends ServerException {
    private String requestId;
    private int statusCode;
    private OSSErrorDetails errorDetails;

    public OSSServerException(OSSErrorDetails error) {
        super();
    }

    public OSSServerException(int statusCode, OSSErrorDetails errorDetails) {
        super();
        this.statusCode = statusCode;
        this.errorDetails = errorDetails;
        this.requestId = errorDetails.requestId();
    }

    public OSSErrorDetails errorDetails() {
        return errorDetails;
    }

    public String requestId() {
        return requestId;
    }

    public int statusCode() {
        return statusCode;
    }

    @Override
    public String getMessage() {
        if (errorDetails != null) {
            return errorDetails().errorMessage() +
                    " (Status Code: " + statusCode() +
                    ", Code: " + errorDetails().errorCode() +
                    ", Request ID: " + requestId() + ")";
        }
        return super.getMessage();
    }
}