package com.aliyun.sdk.gateway.oss.internal;

import java.net.URI;
import java.net.URISyntaxException;

public class OSSEndpointUtil {

    private static URI internetEndpoint(String protocol, String region) {
        return toUri(protocol, "oss-" + region + ".aliyuncs.com");
    }

    private static URI internalEndpoint(String protocol, String region) {
        return toUri(protocol, "oss-" + region + "-internal.aliyuncs.com");
    }

    private static URI ipv6Endpoint(String protocol, String region) {
        return toUri(protocol, region + "oss.aliyuncs.com");
    }

    private static URI accelerateEndpoint(String protocol, String region, String regionType) {
        if (OSSEndpointType.ACCELERATE_OVERSEAS.equalsIgnoreCase(regionType) && !region.startsWith("cn-")) {
            return toUri(protocol, "oss-accelerate-overseas.aliyuncs.com");
        } else {
            return toUri(protocol, "oss-accelerate.aliyuncs.com");
        }
    }

    private static URI toUri(String protocol, String endpoint) {
        try {
            return new URI(String.format("%s://%s", protocol, endpoint));
        } catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}
