package com.aliyun.sdk.gateway.oss.internal.async;

import darabonba.core.TeaResponseHandler;
import darabonba.core.async.AsyncResponseHandler;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

import java.nio.ByteBuffer;
import java.util.zip.Checksum;

public class CheckedAsyncResponseHandler implements AsyncResponseHandler<Object, Object> {
    protected volatile AsyncResponseHandler<?, ?> handler;
    private Checksum cksum;

    public CheckedAsyncResponseHandler(TeaResponseHandler handler, Checksum cksum) {
        this.handler = (AsyncResponseHandler<?, ?>) handler;
        this.cksum = cksum;
    }

    @Override
    public void onStream(Publisher<ByteBuffer> publisher) {
        this.cksum.reset();
        CheckSumProcessor proc = new CheckSumProcessor(cksum);
        this.handler.onStream(proc);
        publisher.subscribe(proc);
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.handler != null) {
            this.handler.onError(throwable);
        }
    }

    @Override
    public Object transform(Object response) {
        return null;
    }

    public Checksum getChecksum() {
        return cksum;
    }

    static class CheckSumProcessor implements Processor<ByteBuffer, ByteBuffer> {
        protected volatile Subscriber<? super ByteBuffer> subscriber;
        protected Checksum cksum;

        CheckSumProcessor(Checksum cksum) {
            this.cksum = cksum;
        }

        @Override
        public void subscribe(final Subscriber<? super ByteBuffer> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public void onSubscribe(Subscription subscription) {
            this.cksum.reset();
            this.subscriber.onSubscribe(subscription);
        }

        @Override
        public void onNext(ByteBuffer byteBuffer) {
            if (byteBuffer.hasRemaining()) {
                cksum.update(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            }
            this.subscriber.onNext(byteBuffer);
        }

        @Override
        public void onError(Throwable throwable) {
            this.subscriber.onError(throwable);
        }

        @Override
        public void onComplete() {
            this.subscriber.onComplete();
        }
    }
}
