package com.aliyun.sdk.gateway.oss.internal.async;

import com.aliyun.core.http.HttpHeaders;
import com.aliyun.core.http.HttpResponseHandler;
import darabonba.core.ResponseBytes;
import darabonba.core.async.AsyncResponseHandler;
import org.reactivestreams.Publisher;

import java.nio.ByteBuffer;

/*
if the http status code >= 300, the result is save into AsyncResponseHandler.toBytes()
otherwise the result is saved into the response handler provided by user.
*/
public class StoredSeparatelyHttpResponseHandler implements HttpResponseHandler {
    protected volatile AsyncResponseHandler<?, ?> asyncResponseHandler;
    protected volatile HttpResponseHandler httpResponseHandler;
    protected volatile AsyncResponseHandler<String, ResponseBytes<String>> errorAsyncResponseHandler;

    public StoredSeparatelyHttpResponseHandler(AsyncResponseHandler<?, ?> asyncResponseHandler) {
        this.asyncResponseHandler = asyncResponseHandler;
        this.httpResponseHandler = null;
    }

    public StoredSeparatelyHttpResponseHandler(HttpResponseHandler httpResponseHandler) {
        this.asyncResponseHandler = null;
        this.httpResponseHandler = httpResponseHandler;
    }

    @Override
    public void onStream(Publisher<ByteBuffer> publisher, int httpStatusCode, HttpHeaders headers) {
        if (httpStatusCode / 100 != 2) {
            errorAsyncResponseHandler = AsyncResponseHandler.toBytes();
            errorAsyncResponseHandler.onStream(publisher);
        } else {
            if (asyncResponseHandler != null) {
                asyncResponseHandler.onStream(publisher);
            } else if (httpResponseHandler != null) {
                httpResponseHandler.onStream(publisher, httpStatusCode, headers);
            }
        }
    }

    @Override
    public void onError(Throwable throwable) {
        if (asyncResponseHandler != null) {
            asyncResponseHandler.onError(throwable);
        } else if (httpResponseHandler != null) {
            httpResponseHandler.onError(throwable);
        }
    }

    public byte[] getErrorBodyByteArrayUnsafe() {
        if (errorAsyncResponseHandler == null) {
            return null;
        }
        ResponseBytes<String> result = errorAsyncResponseHandler.transform("");
        return result.asByteArrayUnsafe();
    }

    public byte[] getErrorBodyByteArray() {
        if (errorAsyncResponseHandler == null) {
            return null;
        }
        ResponseBytes<String> result = errorAsyncResponseHandler.transform("");
        return result.asByteArray();
    }
}
