package com.aliyun.sdk.gateway.oss.internal.interceptor;

import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.DateUtil;
import com.aliyun.core.utils.StringUtils;
import com.aliyun.sdk.gateway.oss.exception.OSSServerException;
import darabonba.core.TeaResponse;
import darabonba.core.client.ClientOption;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.ResponseInterceptor;

import java.util.Date;

public class AdjustClockSkew implements ResponseInterceptor {
    @Override
    public TeaResponse modifyResponse(InterceptorContext context, AttributeMap attributes) {
        TeaResponse response = context.teaResponse();
        if (!response.success()
                && response.httpResponse().getStatusCode() == 403
                && response.exception() instanceof OSSServerException) {
            OSSServerException exception = (OSSServerException) response.exception();
            if ("RequestTimeTooSkewed".equals(exception.errorDetails().errorCode())) {
                try {
                    Date requestTime = DateUtil.parseIso8601Date(exception.errorDetails().getErrorField("RequestTime"));
                    Date serverTime = DateUtil.parseIso8601Date(exception.errorDetails().getErrorField("ServerTime"));
                    Long timeOffset = serverTime.getTime() - requestTime.getTime();
                    context.configuration().clientConfiguration().setOption(ClientOption.CLOCK_SKEW_DIFF, timeOffset);
                } catch (Exception e) {
                }
            }
        }
        return response;
    }
}
