package com.aliyun.sdk.gateway.oss.internal.interceptor;

import com.aliyun.core.http.HttpResponseHandler;
import com.aliyun.core.utils.AttributeMap;
import darabonba.core.TeaRequestBody;
import darabonba.core.async.AsyncResponseHandler;

import java.time.Duration;
import java.time.Instant;
import java.util.List;

public final class AttributeKey<T> extends AttributeMap.Key<T> {

    public static final AttributeKey<List<String>> EXTRA_SUBRESOURCE = new AttributeKey<>(new UnsafeValueType(List.class));
    public static final AttributeKey<TeaRequestBody> REQUEST_BODY = new AttributeKey<>(TeaRequestBody.class);
    public static final AttributeKey<Long> REQUEST_BODY_LENGTH = new AttributeKey<>(Long.class);
    public static final AttributeKey<Boolean> ENABLE_CHECKSUM_CRC64 = new AttributeKey<>(Boolean.class);

    public static final AttributeKey<AsyncResponseHandler> OSS_ASYNC_RESPONSE_HANDLER = new AttributeKey<>(AsyncResponseHandler.class);
    public static final AttributeKey<HttpResponseHandler> OSS_HTTP_RESPONSE_HANDLER = new AttributeKey<>(HttpResponseHandler.class);

    public static final AttributeKey<String> OSS_XML_BODY_CONTENT_MD5 = new AttributeKey<>(String.class);

    public static final AttributeKey<Duration> OSS_SIGNATURE_DURATION = new AttributeKey<>(Duration.class);
    public static final AttributeKey<Instant> OSS_SIGNATURE_EXPIRATION = new AttributeKey<>(Instant.class);
    public static final AttributeKey<Instant> OSS_SIGNATURE_SIGNED_HEADERS = new AttributeKey<>(Instant.class);

    protected AttributeKey(Class<T> valueType) {
        super(valueType);
    }

    protected AttributeKey(UnsafeValueType unsafeValueType) {
        super(unsafeValueType);
    }
}
