package com.aliyun.sdk.gateway.oss.internal.interceptor;

import com.aliyun.core.utils.AttributeMap;
import com.aliyun.sdk.gateway.oss.models.Response;
import com.aliyun.sdk.gateway.oss.models.ResponseMetadata;
import darabonba.core.TeaModel;
import darabonba.core.TeaPair;
import darabonba.core.TeaResponse;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.OutputInterceptor;
import darabonba.core.utils.CommonUtil;

import java.util.Map;

public class FinalizedOutputInterceptor implements OutputInterceptor {

    @Override
    public TeaModel modifyOutput(InterceptorContext context, AttributeMap attributes) {
        TeaResponse response = context.teaResponse();
        Map<String, String> headers = response.httpResponse().getHeaders().toCaseInsensitiveMap();
        Map<String, Object> model = CommonUtil.buildMap(
                new TeaPair("body", response.deserializedBody()),
                new TeaPair("headers", headers));
        TeaModel.adjustToModel(model, context.output());
        updateResponseMembersIfNeed(context, headers);
        return context.output();
    }

    private void updateResponseMembersIfNeed(InterceptorContext context, Map<String, String> headers) {
        if (context.output() instanceof Response) {
            Response res = (Response)context.output();
            context.setOutput(res.toBuilder()
                    .responseMetadata(new ResponseMetadata(headers))
                    .httpStatusCode(context.teaResponse().httpResponse().getStatusCode())
                    .build());
        }
    }
}
