package com.aliyun.sdk.gateway.oss.internal.interceptor;

import com.aliyun.core.http.HttpRequest;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.StringUtils;
import com.aliyun.sdk.gateway.oss.Configuration;
import com.aliyun.sdk.gateway.oss.internal.HttpUtil;
import com.aliyun.sdk.gateway.oss.internal.OSSConstants;
import darabonba.core.TeaRequest;
import darabonba.core.client.ClientConfiguration;
import darabonba.core.client.ClientOption;
import darabonba.core.interceptor.HttpRequestInterceptor;
import darabonba.core.interceptor.InterceptorContext;

import java.net.URI;
import java.net.URL;
import java.util.Optional;

public class GenerateUrlInterceptor implements HttpRequestInterceptor {
    @Override
    public HttpRequest modifyHttpRequest(InterceptorContext context, AttributeMap attributes) {
        final ClientConfiguration configuration = context.configuration().clientConfiguration();
        final Configuration ossConfiguration = (Configuration)configuration.option(ClientOption.SERVICE_CONFIGURATION);
        final TeaRequest request = context.teaRequest();
        HttpRequest httpRequest = context.httpRequest();

        final URI endpointURI = configuration.option(ClientOption.ENDPOINT_URI);

        //scheme
        String scheme = endpointURI.getScheme();

        //port
        int port = endpointURI.getPort();

        //bucket name
        String bucket = Optional.ofNullable(request.hostMap().get("bucket")).orElse("");

        //host & path
        String host = endpointURI.getHost();
        String path = request.pathname();
        if (!StringUtils.isEmpty(bucket)) {
            if (ossConfiguration.cnameEnabled()) {
                path = path.substring(bucket.length() + 1);
            } else if (ossConfiguration.pathStyleEnabled()){
            } else {
                // dns domain, bucket.endpoint
                path = path.substring(bucket.length() + 1);
                host = String.format("%s.%s", bucket, host);
            }
        }

        if (port != -1) {
            host = host + ":" + port;
        }

        //query
        String queryString = HttpUtil.paramToQueryString(request.query(), OSSConstants.DEFAULT_CHARSET_NAME);

        StringBuilder uri = new StringBuilder();
        uri.append(String.format("%s://", scheme));
        uri.append(host);
        uri.append(HttpUtil.urlEncode(path, OSSConstants.DEFAULT_CHARSET_NAME).replace("%2F", "/"));
        uri.append(queryString.isEmpty()? "": ("?" + queryString));

        //update url
        URL url = null;
        try {
            url = new URL(uri.toString());
        } catch (Exception e){
            url = httpRequest.getUrl();
        }
        httpRequest.setUrl(url);
        return httpRequest;
    }
}
