package com.aliyun.sdk.gateway.oss.internal.interceptor;

import com.aliyun.core.http.HttpResponse;
import com.aliyun.core.utils.AttributeMap;
import darabonba.core.TeaResponse;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.ResponseInterceptor;
import darabonba.core.utils.CommonUtil;

public class MakeMutableResponseInterceptor implements ResponseInterceptor {

    @Override
    public TeaResponse modifyResponse(InterceptorContext context, AttributeMap attributes) {
        final HttpResponse httpResponse = context.httpResponse();
        TeaResponse response = new TeaResponse();

        response.setHttpResponse(httpResponse);
        response.setSuccess(CommonUtil.is2xx(httpResponse.getStatusCode()));

        return response;
    }
}
