package com.aliyun.sdk.gateway.oss.internal.interceptor;

import com.aliyun.core.utils.AttributeMap;
import com.aliyun.sdk.gateway.oss.internal.OSSConstants;
import darabonba.core.TeaRequest;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.RequestInterceptor;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.*;

public class ProcPathRegexInterceptor implements RequestInterceptor {

    private static final List<String> NON_SUBRESOUCES = Arrays.asList(new String[] {
            "list-type",
            "regions",
    });

    @Override
    public TeaRequest modifyRequest(InterceptorContext context, AttributeMap attributes) {
        TeaRequest request = context.teaRequest();

        //query
        Map<String, String> query = extractQueryFromPathRegex(request.pathRegex());

        //save subresource into attributes first
        List<String> subResource = new ArrayList<>(query.keySet());
        subResource.removeIf(key -> NON_SUBRESOUCES.contains(key));
        attributes.put(AttributeKey.EXTRA_SUBRESOURCE, subResource);

        query.putAll(request.query());
        request.setQuery(query);

        //append bucket name in the front of pathName
        String pathName = extractPathName(request.pathname(), request.pathRegex());
        if (request.hostMap().containsKey("bucket")) {
            pathName = "/" + request.hostMap().get("bucket") + pathName;
        }
        request.setPathname(pathName);

        return request;
    }

    private static String extractPathName(String pathName, String pathRegex) {
        int index = pathRegex.indexOf("?");
        if (index != -1) {
            pathName = pathName.substring(0, pathName.length() - (pathRegex.length() - index));
        }
        //darabonab encodes the path by default
        try {
            pathName = URLDecoder.decode(pathName, OSSConstants.DEFAULT_CHARSET_NAME);
        } catch (UnsupportedEncodingException e) {
        }
        return pathName;
    }

    private static Map<String, String> extractQueryFromPathRegex(String pathRegex) {
        Map<String, String> query = new HashMap<>();
        int index = pathRegex.indexOf("?");
        if (index != -1) {
            String queryStr = pathRegex.substring(index + 1);
            String[] params = queryStr.split("&");
            for (int i = 0; i < params.length; i++) {
                String[] p = params[i].split("=");
                if (p.length == 2) {
                    query.put(p[0], p[1]);
                } else {
                    query.put(p[0], null);
                }
            }
        }
        return query;
    }
}
