package com.aliyun.sdk.gateway.oss.models;

import darabonba.core.TeaModel;

public abstract class Response extends TeaModel {
    private ResponseMetadata responseMetadata;
    private int httpStatusCode;

    protected Response(BuilderImpl<?, ?> builder) {
        this.responseMetadata = builder.responseMetadata;
        this.httpStatusCode = builder.httpStatusCode;
    }

    public ResponseMetadata getResponseMetadata() {
        return this.responseMetadata;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public abstract Builder toBuilder();

    public interface Builder<ProviderT extends Response, BuilderT extends Response.Builder> {
        BuilderT responseMetadata(ResponseMetadata responseMetadata);

        BuilderT httpStatusCode(int httpStatusCode);

        ProviderT build();
    }

    protected abstract static class BuilderImpl<ProviderT extends Response, BuilderT extends Response.Builder>
            implements Builder<ProviderT, BuilderT> {
        private ResponseMetadata responseMetadata;
        private int httpStatusCode;

        protected BuilderImpl() {
        }

        protected BuilderImpl(Response response) {
            this.responseMetadata = response.responseMetadata;
            this.httpStatusCode = response.httpStatusCode;
        }

        /**
         * ResponseMetadata.
         */
        @Override
        public BuilderT responseMetadata(ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return (BuilderT)this;
        }

        /**
         * httpStatusCode.
         */
        @Override
        public BuilderT httpStatusCode(int httpStatusCode) {
            this.httpStatusCode = httpStatusCode;
            return (BuilderT)this;
        }
    }

}
