package com.aliyun.sdk.gateway.oss.models;

import com.aliyun.sdk.gateway.oss.internal.OSSHeaders;

import java.util.Map;
import java.util.Optional;

public class ResponseMetadata {
    private static final String UNKNOWN = "UNKNOWN";
    private static final String NEGATIVE_ONE = "-1";

    private final Map<String, String> metadata;

    public ResponseMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getRequestId() {
        return getValueAsString(OSSHeaders.REQUEST_ID);
    }

    public long getServerTime() {
        return getValueAsLong(OSSHeaders.SERVER_TIME);
    }

    private final String getValueAsString(String key) {
        try {
            return Optional.ofNullable(metadata.get(key)).orElse(UNKNOWN);
        } catch (Exception e) {
            return UNKNOWN;
        }
    }

    private long getValueAsLong(String key) {
        try {
            return Long.parseLong(Optional.ofNullable(metadata.get(key)).orElse(NEGATIVE_ONE));
        } catch (Exception e) {
            return -1;
        }
    }

    private long getValueAsInt(String key) {
        try {
            return Integer.parseInt(Optional.ofNullable(metadata.get(key)).orElse(NEGATIVE_ONE));
        } catch (Exception e) {
            return -1;
        }
    }
}
