package com.aliyun.sdk.gateway.oss.policy.retry;

import com.aliyun.sdk.gateway.oss.exception.InconsistentException;
import com.aliyun.sdk.gateway.oss.policy.retry.conditions.RetryOnErrorCodeCondition;
import darabonba.core.policy.retry.RetryPolicy;
import darabonba.core.policy.retry.conditions.ExceptionsCondition;
import darabonba.core.policy.retry.conditions.OrRetryCondition;
import darabonba.core.policy.retry.conditions.RetryCondition;
import darabonba.core.policy.retry.conditions.StatusCodeCondition;

import javax.net.ssl.SSLException;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public final class OSSRetryPolicy {
    private static int SC_INTERNAL_SERVER_ERROR = 500;
    private static int SC_BAD_GATEWAY = 502;
    private static int SC_SERVICE_UNAVAILABLE = 503;
    private static int SC_GATEWAY_TIMEOUT = 504;

    public static RetryPolicy defaultRetryPolicy() {
        return RetryPolicy.defaultRetryPolicy().toBuilder()
                .retryCondition(OSSRetryPolicy.defaultRetryCondition())
                .build();
    }

    private static RetryCondition defaultRetryCondition() {
        return OrRetryCondition.create(
                /*Http Status Code*/
                StatusCodeCondition.create(
                        SC_INTERNAL_SERVER_ERROR,
                        SC_BAD_GATEWAY,
                        SC_SERVICE_UNAVAILABLE,
                        SC_GATEWAY_TIMEOUT
                ),
                /*Common Client Exception*/
                ExceptionsCondition.create(
                        SocketTimeoutException.class,
                        SocketException.class,
                        SSLException.class,
                        IOException.class
                ),
                /*OSS Server Error Code*/
                RetryOnErrorCodeCondition.create(
                        "RequestTimeTooSkewed"
                ),
                /*OSS Client Exception*/
                ExceptionsCondition.create(
                        InconsistentException.class
                )
        );
    }
}
