/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.oss.internal.interceptor;

import com.aliyun.core.http.HttpRequest;
import com.aliyun.core.utils.AttributeMap;
import com.aliyun.core.utils.StringUtils;
import com.aliyun.sdk.gateway.oss.Configuration;
import com.aliyun.sdk.gateway.oss.internal.HttpUtil;
import darabonba.core.TeaRequest;
import darabonba.core.client.ClientConfiguration;
import darabonba.core.client.ClientOption;
import darabonba.core.interceptor.HttpRequestInterceptor;
import darabonba.core.interceptor.InterceptorContext;
import java.net.URI;
import java.net.URL;
import java.util.Optional;

public class GenerateUrlInterceptor
implements HttpRequestInterceptor {
    public HttpRequest modifyHttpRequest(InterceptorContext context, AttributeMap attributes) {
        ClientConfiguration configuration = context.configuration().clientConfiguration();
        Configuration ossConfiguration = (Configuration)configuration.option(ClientOption.SERVICE_CONFIGURATION);
        TeaRequest request = context.teaRequest();
        HttpRequest httpRequest = context.httpRequest();
        URI endpointURI = (URI)configuration.option(ClientOption.ENDPOINT_URI);
        String scheme = endpointURI.getScheme();
        int port = endpointURI.getPort();
        String bucket = Optional.ofNullable(request.hostMap().get("bucket")).orElse("");
        String host = endpointURI.getHost();
        String path = request.pathname();
        if (!StringUtils.isEmpty((CharSequence)bucket)) {
            if (ossConfiguration.cnameEnabled()) {
                path = path.substring(bucket.length() + 1);
            } else if (!ossConfiguration.pathStyleEnabled()) {
                path = path.substring(bucket.length() + 1);
                host = String.format("%s.%s", bucket, host);
            }
        }
        if (port != -1) {
            host = host + ":" + port;
        }
        String queryString = HttpUtil.paramToQueryString(request.query(), "utf-8");
        StringBuilder uri = new StringBuilder();
        uri.append(String.format("%s://", scheme));
        uri.append(host);
        uri.append(HttpUtil.urlEncode(path, "utf-8").replace("%2F", "/"));
        uri.append(queryString.isEmpty() ? "" : "?" + queryString);
        URL url = null;
        try {
            url = new URL(uri.toString());
        }
        catch (Exception e) {
            url = httpRequest.getUrl();
        }
        httpRequest.setUrl(url);
        return httpRequest;
    }
}

