/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.gateway.oss.internal.interceptor;

import com.aliyun.core.utils.AttributeMap;
import com.aliyun.sdk.gateway.oss.internal.interceptor.AttributeKey;
import darabonba.core.TeaRequest;
import darabonba.core.interceptor.InterceptorContext;
import darabonba.core.interceptor.RequestInterceptor;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcPathRegexInterceptor
implements RequestInterceptor {
    private static final List<String> NON_SUBRESOUCES = Arrays.asList("list-type", "regions");

    public TeaRequest modifyRequest(InterceptorContext context, AttributeMap attributes) {
        TeaRequest request = context.teaRequest();
        Map<String, String> query = ProcPathRegexInterceptor.extractQueryFromPathRegex(request.pathRegex());
        ArrayList<String> subResource = new ArrayList<String>(query.keySet());
        subResource.removeIf(key -> NON_SUBRESOUCES.contains(key));
        attributes.put(AttributeKey.EXTRA_SUBRESOURCE, subResource);
        query.putAll(request.query());
        request.setQuery(query);
        String pathName = ProcPathRegexInterceptor.extractPathName(request.pathname(), request.pathRegex());
        if (request.hostMap().containsKey("bucket")) {
            pathName = "/" + (String)request.hostMap().get("bucket") + pathName;
        }
        request.setPathname(pathName);
        return request;
    }

    private static String extractPathName(String pathName, String pathRegex) {
        int index = pathRegex.indexOf("?");
        if (index != -1) {
            pathName = pathName.substring(0, pathName.length() - (pathRegex.length() - index));
        }
        try {
            pathName = URLDecoder.decode(pathName, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return pathName;
    }

    private static Map<String, String> extractQueryFromPathRegex(String pathRegex) {
        HashMap<String, String> query = new HashMap<String, String>();
        int index = pathRegex.indexOf("?");
        if (index != -1) {
            String queryStr = pathRegex.substring(index + 1);
            String[] params = queryStr.split("&");
            for (int i = 0; i < params.length; ++i) {
                String[] p = params[i].split("=");
                if (p.length == 2) {
                    query.put(p[0], p[1]);
                    continue;
                }
                query.put(p[0], null);
            }
        }
        return query;
    }
}

