package com.aliyun.sdk.gateway.pop.auth;

import com.aliyun.auth.signature.exception.SignatureException;
import com.aliyun.core.http.HttpMethod;
import com.aliyun.core.utils.StringUtils;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Map;

import static com.aliyun.core.utils.EncodeUtil.percentEncode;

public class RpcSignatureComposer {
    private final static String SEPARATOR = "&";

    public static String composeStringToSign(HttpMethod method, Map<String, String> params,
                                             Map<String, String> headers, String pathname) {
        StringBuilder stringToSign = new StringBuilder();
        try {
            stringToSign.append(method);
            stringToSign.append(SEPARATOR);
            stringToSign.append(percentEncode(pathname));
            stringToSign.append(SEPARATOR);
            stringToSign.append(percentEncode(
                    buildCanonicalizedResource(params)));
        } catch (UnsupportedEncodingException e) {
            throw new SignatureException(e.toString());
        }
        return stringToSign.toString();
    }

    private static String buildCanonicalizedResource(Map<String, String> params) {
        String[] sortedKeys = params.keySet().toArray(new String[]{});
        Arrays.sort(sortedKeys);
        StringBuilder queryString = new StringBuilder();
        try {
            for (String key : sortedKeys) {
                if (null != params.get(key)) {
                    queryString.append(SEPARATOR)
                            .append(percentEncode(key)).append("=")
                            .append(percentEncode(params.get(key)));
                }
            }
        } catch (UnsupportedEncodingException e) {
            throw new SignatureException(e.toString());
        }
        return queryString.length() > 0 ? queryString.substring(1) : StringUtils.EMPTY;
    }
}
