package com.aliyun.sdk.gateway.pop.clients;

import com.aliyun.core.utils.SdkAutoCloseable;
import com.aliyun.sdk.gateway.pop.Configuration;
import com.aliyun.sdk.gateway.pop.auth.SignatureVersion;
import com.aliyun.sdk.gateway.pop.models.CommonRequest;
import com.aliyun.sdk.gateway.pop.models.CommonResponse;
import darabonba.core.*;
import darabonba.core.client.ClientConfiguration;
import darabonba.core.client.ClientExecutionParams;

public final class CommonClient implements SdkAutoCloseable {
    private final TeaAsyncHandler handler;

    CommonClient(ClientConfiguration configuration) {
        this.handler = new TeaAsyncHandler(configuration);
    }

    public static CommonClientBuilder builder() {
        return new CommonClientBuilder().serviceConfiguration(Configuration.create().setSignatureVersion(SignatureVersion.V3));
    }

    static CommonClient create() {
        return builder().build();
    }

    @Override
    public void close() {
        this.handler.close();
    }

    public CommonResponse callApi(CommonRequest request) {
        this.handler.validateRequestModel(request);
        TeaRequest teaRequest = TeaRequest.create()
                .setProduct(request.getProduct())
                .setVersion(request.getVersion())
                .setStyle(request.getPath().equals("/") ? RequestStyle.RPC : RequestStyle.RESTFUL)
                .setAction(request.getAction())
                .setMethod(request.getHttpMethod())
                .setPathRegex(request.getPath())
                .setReqBodyType(request.getRequestBodyType())
                .setBodyType(request.getResponseBodyType())
                .setBodyIsForm(request.isFormData())
                .formModel(request);
        ClientExecutionParams<CommonRequest, CommonResponse> params = new ClientExecutionParams<CommonRequest, CommonResponse>()
                .withInput(request)
                .withRequest(teaRequest)
                .withOutput(CommonResponse.create());
        return this.handler.execute(params).join();
    }

}
