package com.aliyun.auth.credentials.provider;

import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.ICredential;
import com.aliyun.auth.credentials.exception.*;
import com.aliyun.auth.credentials.utils.*;
import com.aliyun.core.utils.StringUtils;

public class SystemPropertiesCredentialProvider implements ICredentialProvider {

    public static SystemPropertiesCredentialProvider create() {
        return new SystemPropertiesCredentialProvider();
    }

    @Override
    public ICredential getCredentials() throws CredentialException {
        String accessKeyId = System.getProperty(AuthConstant.SYSTEM_ACCESSKEYID);
        String accessKeySecret = System.getProperty(AuthConstant.SYSTEM_ACCESSKEY_SECRET);
        if (!StringUtils.isEmpty(System.getProperty(AuthConstant.SYSTEM_ACCESSKEYSECRET))) {
            accessKeySecret = System.getProperty(AuthConstant.SYSTEM_ACCESSKEYSECRET);
        }
        String securityToken = System.getProperty(AuthConstant.SYSTEM_SESSION_TOKEN);
        if (StringUtils.isEmpty(accessKeyId) || StringUtils.isEmpty(accessKeySecret)) {
            throw new CredentialException("System Properties variable accessKeyId/accessKeySecret cannot be empty");
        }
        if (!StringUtils.isEmpty(securityToken)) {
            return Credential.builder()
                    .accessKeyId(accessKeyId)
                    .accessKeySecret(accessKeySecret)
                    .securityToken(securityToken)
                    .build();
        }
        return Credential.builder()
                .accessKeyId(accessKeyId)
                .accessKeySecret(accessKeySecret)
                .build();
    }

    @Override
    public void close() {
    }
}
