/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.regions;

import com.aliyuncs.AcsError;
import com.aliyuncs.auth.Credential;
import com.aliyuncs.auth.ISigner;
import com.aliyuncs.auth.ShaHmac1Singleton;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpRequest;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.reader.Reader;
import com.aliyuncs.reader.ReaderFactory;
import com.aliyuncs.regions.DescribeEndpointRequest;
import com.aliyuncs.regions.DescribeEndpointResponse;
import com.aliyuncs.regions.DescribeEndpointService;
import com.aliyuncs.regions.LocationConfig;
import com.aliyuncs.regions.ProductDomain;
import com.aliyuncs.transform.UnmarshallerContext;
import java.io.UnsupportedEncodingException;

public class DescribeEndpointServiceImpl
implements DescribeEndpointService {
    private static final String DEFAULT_ENDPOINT_TYPE = "openAPI";

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    @Override
    public DescribeEndpointResponse describeEndpoint(String regionId, String serviceCode, String endpointType, Credential credential, LocationConfig locationConfig) {
        if (this.isEmpty(serviceCode)) {
            return null;
        }
        DescribeEndpointRequest request = new DescribeEndpointRequest();
        request.setAcceptFormat(FormatType.JSON);
        request.setId(regionId);
        request.setRegionId(locationConfig.getRegionId());
        request.setLocationProduct(serviceCode);
        request.setSecurityToken(credential.getSecurityToken());
        if (this.isEmpty(endpointType)) {
            endpointType = DEFAULT_ENDPOINT_TYPE;
        }
        request.setEndpointType(endpointType);
        ISigner signer = ShaHmac1Singleton.INSTANCE.getInstance();
        ProductDomain domain = new ProductDomain(locationConfig.getProduct(), locationConfig.getEndpoint());
        try {
            HttpRequest httpRequest = request.signRequest(signer, credential, FormatType.JSON, domain);
            HttpResponse httpResponse = HttpResponse.getResponse(httpRequest);
            if (httpResponse.isSuccess()) {
                String data = new String(httpResponse.getContent(), "utf-8");
                DescribeEndpointResponse response = this.getEndpointResponse(data, endpointType);
                if (response == null || this.isEmpty(response.getEndpoint())) {
                    return null;
                }
                return response;
            }
            AcsError error = this.readError(httpResponse, FormatType.JSON);
            if (500 <= httpResponse.getStatus()) {
                System.out.println("Invoke_Error, requestId:" + error.getRequestId() + "; code:" + error.getErrorCode() + "; Msg" + error.getErrorMessage());
                return null;
            }
            System.out.println("Invoke_Error, requestId:" + error.getRequestId() + "; code:" + error.getErrorCode() + "; Msg" + error.getErrorMessage());
            return null;
        }
        catch (Throwable e) {
            System.out.println("Invoke Remote Error,Msg" + e.getMessage());
            return null;
        }
    }

    private DescribeEndpointResponse getEndpointResponse(String data, String endpointType) throws ClientException {
        Reader reader = ReaderFactory.createInstance(FormatType.JSON);
        UnmarshallerContext context = new UnmarshallerContext();
        context.setResponseMap(reader.read(data, "DescribeEndpointsResponse"));
        int endpointsLength = context.lengthValue("DescribeEndpointsResponse.Endpoints.Length");
        for (int i = 0; i < endpointsLength; ++i) {
            if (!endpointType.equalsIgnoreCase(context.stringValue("DescribeEndpointsResponse.Endpoints[" + i + "].Type"))) continue;
            DescribeEndpointResponse response = new DescribeEndpointResponse();
            response.setRequestId(context.stringValue("DescribeEndpointsResponse.RequestId"));
            response.setProduct(context.stringValue("DescribeEndpointsResponse.Endpoints[" + i + "].SerivceCode"));
            response.setEndpoint(context.stringValue("DescribeEndpointsResponse.Endpoints[" + i + "].Endpoint"));
            response.setRegionId(context.stringValue("DescribeEndpointsResponse.Endpoints[" + i + "].Id"));
            return response;
        }
        return null;
    }

    private AcsError readError(HttpResponse httpResponse, FormatType format) throws ClientException {
        AcsError error = new AcsError();
        String responseEndpoint = "Error";
        Reader reader = ReaderFactory.createInstance(format);
        UnmarshallerContext context = new UnmarshallerContext();
        String stringContent = this.getResponseContent(httpResponse);
        context.setResponseMap(reader.read(stringContent, responseEndpoint));
        error = error.getInstance(context);
        if (httpResponse.getStatus() > 0) {
            error.setStatusCode(httpResponse.getStatus());
        }
        return error;
    }

    private String getResponseContent(HttpResponse httpResponse) throws ClientException {
        String stringContent = null;
        try {
            stringContent = null == httpResponse.getEncoding() ? new String(httpResponse.getContent()) : new String(httpResponse.getContent(), httpResponse.getEncoding());
        }
        catch (UnsupportedEncodingException exp) {
            throw new ClientException("SDK.UnsupportedEncoding", "Can not parse response due to un supported encoding.");
        }
        return stringContent;
    }
}

